/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class LimitedPool<T> {
    private final int myMaxCapacity;
    private final ObjectFactory<T> myFactory;
    private Object[] myStorage = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private int myIndex;

    public LimitedPool(int maxCapacity, @NotNull ObjectFactory<T> factory) {
        this.myMaxCapacity = maxCapacity;
        this.myFactory = factory;
    }

    @NotNull
    public T alloc() {
        if (this.myIndex == 0) {
            return this.myFactory.create();
        }
        int i = --this.myIndex;
        Object result = this.myStorage[i];
        this.myStorage[i] = null;
        return (T)result;
    }

    public void recycle(@NotNull T t) {
        this.myFactory.cleanup(t);
        if (this.myIndex >= this.myMaxCapacity) {
            return;
        }
        this.ensureCapacity();
        this.myStorage[this.myIndex++] = t;
    }

    private void ensureCapacity() {
        if (this.myStorage.length <= this.myIndex) {
            int newCapacity = Math.min(this.myMaxCapacity, Math.max(10, this.myStorage.length * 3 / 2));
            this.myStorage = ArrayUtil.realloc(this.myStorage, newCapacity, ArrayUtil.OBJECT_ARRAY_FACTORY);
        }
    }

    public static final class Sync<T>
    extends LimitedPool<T> {
        public Sync(int maxCapacity, @NotNull ObjectFactory<T> factory) {
            super(maxCapacity, factory);
        }

        @Override
        @NotNull
        public synchronized T alloc() {
            return super.alloc();
        }

        @Override
        public synchronized void recycle(@NotNull T t) {
            super.recycle(t);
        }
    }

    @FunctionalInterface
    public static interface ObjectFactory<T> {
        @NotNull
        public T create();

        default public void cleanup(@NotNull T t) {
        }
    }
}

