/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="myMap.entrySet().toArray()")
public class MostlySingularMultiMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 2784473565881807109L;
    protected final Map<K, Object> myMap = this.createMap();
    private static final MostlySingularMultiMap EMPTY = new EmptyMap();

    @NotNull
    protected Map<K, Object> createMap() {
        return new THashMap();
    }

    public void add(@NotNull K key, @NotNull V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            this.myMap.put(key, value);
        } else if (current instanceof ValueList) {
            ValueList curList = (ValueList)current;
            curList.add(value);
        } else {
            ValueList newList = new ValueList();
            newList.add(current);
            newList.add(value);
            this.myMap.put(key, newList);
        }
    }

    public boolean remove(@NotNull K key, @NotNull V value) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return false;
        }
        if (current instanceof ValueList) {
            ValueList curList = (ValueList)current;
            return curList.remove(value);
        }
        if (value.equals(current)) {
            this.myMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeAllValues(@NotNull K key) {
        return this.myMap.remove(key) != null;
    }

    @NotNull
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public boolean processForKey(@NotNull K key, @NotNull Processor<? super V> p) {
        return this.processValue(p, this.myMap.get(key));
    }

    private boolean processValue(@NotNull Processor<? super V> p, Object v) {
        if (v instanceof ValueList) {
            for (Object o : (ValueList)v) {
                if (p.process(o)) continue;
                return false;
            }
        } else if (v != null) {
            return p.process(v);
        }
        return true;
    }

    public boolean processAllValues(@NotNull Processor<? super V> p) {
        for (Object v : this.myMap.values()) {
            if (this.processValue(p, v)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.myMap.size();
    }

    public boolean containsKey(@NotNull K key) {
        return this.myMap.containsKey(key);
    }

    public int valuesForKey(@NotNull K key) {
        Object current = this.myMap.get(key);
        if (current == null) {
            return 0;
        }
        if (current instanceof ValueList) {
            return ((ValueList)current).size();
        }
        return 1;
    }

    @NotNull
    public Iterable<V> get(@NotNull K name) {
        Object value = this.myMap.get(name);
        return this.rawValueToCollection(value);
    }

    @NotNull
    protected List<V> rawValueToCollection(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof ValueList) {
            return (ValueList)value;
        }
        return Collections.singletonList(value);
    }

    public void compact() {
        ((THashMap)this.myMap).compact();
        for (Object eachValue : this.myMap.values()) {
            if (!(eachValue instanceof ValueList)) continue;
            ((ValueList)eachValue).trimToSize();
        }
    }

    public String toString() {
        return "{" + StringUtil.join(this.myMap.entrySet(), entry -> {
            Object value = entry.getValue();
            String s = (value instanceof ValueList ? (ValueList)value : Collections.singletonList(value)).toString();
            return entry.getKey() + ": " + s;
        }, "; ") + "}";
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> emptyMap() {
        return EMPTY;
    }

    @NotNull
    public static <K, V> MostlySingularMultiMap<K, V> newMap() {
        return new MostlySingularMultiMap<K, V>();
    }

    public void addAll(MostlySingularMultiMap<K, V> other) {
        if (other instanceof EmptyMap) {
            return;
        }
        for (Map.Entry<K, Object> entry : other.myMap.entrySet()) {
            K key = entry.getKey();
            Object otherValue = entry.getValue();
            Object myValue = this.myMap.get(key);
            if (myValue == null) {
                if (otherValue instanceof ValueList) {
                    this.myMap.put(key, new ValueList((ValueList)otherValue));
                    continue;
                }
                this.myMap.put(key, otherValue);
                continue;
            }
            if (myValue instanceof ValueList) {
                ValueList myListValue = (ValueList)myValue;
                if (otherValue instanceof ValueList) {
                    myListValue.addAll((ValueList)otherValue);
                    continue;
                }
                myListValue.add(otherValue);
                continue;
            }
            if (otherValue instanceof ValueList) {
                ValueList otherListValue = (ValueList)otherValue;
                ValueList newList = new ValueList(otherListValue.size() + 1);
                newList.add(myValue);
                newList.addAll(otherListValue);
                this.myMap.put(key, newList);
                continue;
            }
            ValueList newList = new ValueList();
            newList.add(myValue);
            newList.add(otherValue);
            this.myMap.put(key, newList);
        }
    }

    private static class EmptyMap
    extends MostlySingularMultiMap {
        private EmptyMap() {
        }

        public void add(@NotNull Object key, @NotNull Object value) {
            throw new IncorrectOperationException();
        }

        public boolean remove(@NotNull Object key, @NotNull Object value) {
            throw new IncorrectOperationException();
        }

        public boolean removeAllValues(@NotNull Object key) {
            throw new IncorrectOperationException();
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Set keySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean processForKey(@NotNull Object key, @NotNull Processor p) {
            return true;
        }

        public boolean processAllValues(@NotNull Processor p) {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        public int valuesForKey(@NotNull Object key) {
            return 0;
        }

        @NotNull
        public Iterable get(@NotNull Object name) {
            return ContainerUtil.emptyList();
        }
    }

    protected static class ValueList<V>
    extends ArrayList<V> {
        public ValueList() {
        }

        public ValueList(int initialCapacity) {
            super(initialCapacity);
        }

        public ValueList(@NotNull Collection<? extends V> c) {
            super(c);
        }
    }
}

