/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class WeakInterner<T> {
    private final ConcurrentMap<T, T> myMap;

    public WeakInterner() {
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    }

    public WeakInterner(@NotNull TObjectHashingStrategy<? super T> strategy) {
        this.myMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(strategy);
    }

    @NotNull
    public T intern(@NotNull T name) {
        return ConcurrencyUtil.cacheOrGet(this.myMap, name, name);
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public Set<T> getValues() {
        return ContainerUtil.newTroveSet(this.myMap.values());
    }
}

