/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.openapi.util.Ref;
import com.intellij.util.ThreeState;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DiffTree<OT, NT> {
    private static final int CHANGE_PARENT_VERSUS_CHILDREN_THRESHOLD = 20;
    private final FlyweightCapableTreeStructure<OT> myOldTree;
    private final FlyweightCapableTreeStructure<NT> myNewTree;
    private final ShallowNodeComparator<OT, NT> myComparator;
    private final List<Ref<OT[]>> myOldChildrenLists = new ArrayList<Ref<OT[]>>();
    private final List<Ref<NT[]>> myNewChildrenLists = new ArrayList<Ref<NT[]>>();
    private final CharSequence myOldText;
    private final CharSequence myNewText;
    private final int myOldTreeStart;
    private final int myNewTreeStart;
    private static final DiffTreeChangeBuilder EMPTY_CONSUMER = new DiffTreeChangeBuilder(){

        public void nodeReplaced(@NotNull Object oldChild, @NotNull Object newChild) {
        }

        public void nodeDeleted(@NotNull Object oldParent, @NotNull Object oldNode) {
        }

        public void nodeInserted(@NotNull Object oldParent, @NotNull Object newNode, int pos) {
        }
    };

    private DiffTree(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull CharSequence oldText) {
        this.myOldTree = oldTree;
        this.myNewTree = newTree;
        this.myComparator = comparator;
        this.myOldText = oldText;
        this.myOldTreeStart = oldTree.getStartOffset(oldTree.getRoot());
        this.myNewText = newTree.toString(newTree.getRoot());
        this.myNewTreeStart = newTree.getStartOffset(newTree.getRoot());
    }

    public static <OT, NT> void diff(@NotNull FlyweightCapableTreeStructure<OT> oldTree, @NotNull FlyweightCapableTreeStructure<NT> newTree, @NotNull ShallowNodeComparator<OT, NT> comparator, @NotNull DiffTreeChangeBuilder<OT, NT> consumer, @NotNull CharSequence oldText) {
        DiffTree<OT, NT> tree = new DiffTree<OT, NT>(oldTree, newTree, comparator, oldText);
        super.build(oldTree.getRoot(), newTree.getRoot(), 0, consumer);
    }

    @NotNull
    private static <OT, NT> DiffTreeChangeBuilder<OT, NT> emptyConsumer() {
        return EMPTY_CONSUMER;
    }

    @NotNull
    private CompareResult build(@NotNull OT oldNode, @NotNull NT newNode, int level, @NotNull DiffTreeChangeBuilder<OT, NT> consumer) {
        CompareResult result;
        if (level == this.myNewChildrenLists.size()) {
            this.myNewChildrenLists.add(new Ref());
            this.myOldChildrenLists.add(new Ref());
        }
        Ref<T[]> oldChildrenR = this.myOldChildrenLists.get(level);
        int oldChildrenSize = this.myOldTree.getChildren(oldNode, oldChildrenR);
        T[] oldChildren = oldChildrenR.get();
        Ref<T[]> newChildrenR = this.myNewChildrenLists.get(level);
        int newChildrenSize = this.myNewTree.getChildren(newNode, newChildrenR);
        T[] newChildren = newChildrenR.get();
        if (Math.abs(oldChildrenSize - newChildrenSize) > 20) {
            consumer.nodeReplaced(oldNode, newNode);
            result = CompareResult.NOT_EQUAL;
        } else if (oldChildrenSize == 0 && newChildrenSize == 0) {
            if (!this.myComparator.hashCodesEqual(oldNode, newNode) || !this.myComparator.typesEqual(oldNode, newNode)) {
                consumer.nodeReplaced(oldNode, newNode);
                result = CompareResult.NOT_EQUAL;
            } else {
                result = CompareResult.EQUAL;
            }
        } else {
            int minSize = Math.min(oldChildrenSize, newChildrenSize);
            int suffixLength = this.match(oldChildren, oldChildrenSize - 1, newChildren, newChildrenSize - 1, level, -1, minSize);
            int maxPrefixLength = minSize - suffixLength - (oldChildrenSize == newChildrenSize && suffixLength < minSize ? 1 : 0);
            int prefixLength = this.match(oldChildren, 0, newChildren, 0, level, 1, maxPrefixLength);
            if (oldChildrenSize == newChildrenSize && suffixLength + prefixLength == oldChildrenSize) {
                result = CompareResult.EQUAL;
            } else if (consumer == DiffTree.emptyConsumer()) {
                result = CompareResult.NOT_EQUAL;
            } else {
                int oldIndex = prefixLength;
                int newIndex = prefixLength;
                while (oldIndex < oldChildrenSize - suffixLength || newIndex < newChildrenSize - suffixLength) {
                    ThreeElementMatchResult vicinityMatch = this.matchNext3Children(oldChildren, newChildren, oldIndex, newIndex, oldChildrenSize - suffixLength, newChildrenSize - suffixLength);
                    if (vicinityMatch.hasStartMatch()) {
                        if (vicinityMatch == ThreeElementMatchResult.drillDownStartMatch) {
                            this.build(oldChildren[oldIndex], newChildren[newIndex], level + 1, consumer);
                        } else if (vicinityMatch == ThreeElementMatchResult.replaceStart) {
                            consumer.nodeReplaced(oldChildren[oldIndex], newChildren[newIndex]);
                        }
                        ++oldIndex;
                        ++newIndex;
                        continue;
                    }
                    if (vicinityMatch != ThreeElementMatchResult.noMatch) {
                        int i;
                        for (i = vicinityMatch.skipOldCount() - 1; i >= 0; --i) {
                            consumer.nodeDeleted(oldNode, oldChildren[oldIndex]);
                            ++oldIndex;
                        }
                        for (i = vicinityMatch.skipNewCount() - 1; i >= 0; --i) {
                            consumer.nodeInserted(oldNode, newChildren[newIndex], newIndex);
                            ++newIndex;
                        }
                        continue;
                    }
                    int suffixMatch = this.matchLastChildren(level, consumer, oldChildrenSize - suffixLength, oldChildren, oldIndex, newChildrenSize - suffixLength, newChildren, newIndex);
                    if (suffixMatch > 0) {
                        suffixLength += suffixMatch;
                        continue;
                    }
                    consumer.nodeReplaced(oldChildren[oldIndex], newChildren[newIndex]);
                    ++oldIndex;
                    ++newIndex;
                }
                result = CompareResult.NOT_EQUAL;
            }
        }
        this.myOldTree.disposeChildren(oldChildren, oldChildrenSize);
        this.myNewTree.disposeChildren(newChildren, newChildrenSize);
        return result;
    }

    private ThreeElementMatchResult matchNext3Children(OT[] oldChildren, NT[] newChildren, int oldIndex, int newIndex, int oldLimit, int newLimit) {
        NT newChild3;
        if (oldIndex >= oldLimit) {
            return ThreeElementMatchResult.skipNew1;
        }
        if (newIndex >= newLimit) {
            return ThreeElementMatchResult.skipOld1;
        }
        OT oldChild1 = oldChildren[oldIndex];
        NT newChild1 = newChildren[newIndex];
        CompareResult c11 = this.looksEqual(oldChild1, newChild1);
        if (c11 == CompareResult.EQUAL) {
            return ThreeElementMatchResult.fullStartMatch;
        }
        if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.drillDownStartMatch;
        }
        OT oldChild2 = oldIndex < oldLimit - 1 ? (OT)oldChildren[oldIndex + 1] : null;
        NT newChild2 = newIndex < newLimit - 1 ? (NT)newChildren[newIndex + 1] : null;
        CompareResult c12 = this.looksEqual(oldChild1, newChild2);
        if (c12 == CompareResult.EQUAL || c12 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.skipNew1;
        }
        CompareResult c21 = this.looksEqual(oldChild2, newChild1);
        if (c21 == CompareResult.EQUAL || c21 == CompareResult.DRILL_DOWN_NEEDED) {
            return ThreeElementMatchResult.skipOld1;
        }
        if (c11 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.replaceStart;
        }
        if (c12 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.skipNew1;
        }
        if (c21 == CompareResult.TYPE_ONLY) {
            return ThreeElementMatchResult.skipOld1;
        }
        OT oldChild3 = oldIndex < oldLimit - 2 ? (OT)oldChildren[oldIndex + 2] : null;
        NT NT = newChild3 = newIndex < newLimit - 2 ? (NT)newChildren[newIndex + 2] : null;
        if (this.looksEqual(oldChild1, newChild3) != CompareResult.NOT_EQUAL) {
            return ThreeElementMatchResult.skipNew2;
        }
        if (this.looksEqual(oldChild3, newChild1) != CompareResult.NOT_EQUAL) {
            return ThreeElementMatchResult.skipOld2;
        }
        return ThreeElementMatchResult.noMatch;
    }

    private int matchLastChildren(int level, DiffTreeChangeBuilder<OT, NT> consumer, int oldChildrenLimit, OT[] oldChildren, int oldIndex, int newChildrenLimit, NT[] newChildren, int newIndex) {
        NT newLastChild;
        OT oldLastChild;
        CompareResult c;
        int len = 0;
        while (oldIndex < oldChildrenLimit - len && newIndex < newChildrenLimit - len && (c = this.looksEqual(oldLastChild = oldChildren[oldChildrenLimit - len - 1], newLastChild = newChildren[newChildrenLimit - len - 1])) != CompareResult.NOT_EQUAL) {
            if (c == CompareResult.DRILL_DOWN_NEEDED) {
                this.build(oldLastChild, newLastChild, level + 1, consumer);
            } else if (c == CompareResult.TYPE_ONLY) {
                consumer.nodeReplaced(oldLastChild, newLastChild);
            }
            ++len;
        }
        return len;
    }

    private int match(OT[] oldChildren, int oldIndex, NT[] newChildren, int newIndex, int level, int step, int maxLength) {
        int delta;
        for (delta = 0; delta != maxLength * step; delta += step) {
            OT oldChild = oldChildren[oldIndex + delta];
            NT newChild = newChildren[newIndex + delta];
            CompareResult c11 = this.looksEqual(oldChild, newChild);
            if (c11 == CompareResult.DRILL_DOWN_NEEDED) {
                CompareResult compareResult = c11 = this.textMatch(oldChild, newChild) ? this.build(oldChild, newChild, level + 1, DiffTree.emptyConsumer()) : CompareResult.NOT_EQUAL;
                assert (c11 != CompareResult.DRILL_DOWN_NEEDED);
            }
            if (c11 != CompareResult.EQUAL) break;
        }
        return delta * step;
    }

    private boolean textMatch(OT oldChild, NT newChild) {
        int oldStart = this.myOldTree.getStartOffset(oldChild) - this.myOldTreeStart;
        int oldEnd = this.myOldTree.getEndOffset(oldChild) - this.myOldTreeStart;
        int newStart = this.myNewTree.getStartOffset(newChild) - this.myNewTreeStart;
        int newEnd = this.myNewTree.getEndOffset(newChild) - this.myNewTreeStart;
        return CharArrayUtil.regionMatches(this.myOldText, oldStart, oldEnd, this.myNewText, newStart, newEnd);
    }

    @NotNull
    private CompareResult looksEqual(OT oldChild1, NT newChild1) {
        if (oldChild1 == null || newChild1 == null || !this.myComparator.typesEqual(oldChild1, newChild1)) {
            return CompareResult.NOT_EQUAL;
        }
        ThreeState ret = this.myComparator.deepEqual(oldChild1, newChild1);
        if (ret == ThreeState.YES) {
            return CompareResult.EQUAL;
        }
        if (ret == ThreeState.UNSURE) {
            return CompareResult.DRILL_DOWN_NEEDED;
        }
        return CompareResult.TYPE_ONLY;
    }

    private static enum ThreeElementMatchResult {
        fullStartMatch,
        drillDownStartMatch,
        replaceStart,
        skipNew1,
        skipNew2,
        skipOld1,
        skipOld2,
        noMatch;


        final int skipNewCount() {
            return this == skipNew1 ? 1 : (this == skipNew2 ? 2 : 0);
        }

        final int skipOldCount() {
            return this == skipOld1 ? 1 : (this == skipOld2 ? 2 : 0);
        }

        final boolean hasStartMatch() {
            return this == fullStartMatch || this == drillDownStartMatch || this == replaceStart;
        }
    }

    private static enum CompareResult {
        EQUAL,
        DRILL_DOWN_NEEDED,
        TYPE_ONLY,
        NOT_EQUAL;

    }
}

