/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.EmptyIntHashSet;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class InvertedIndexUtil {
    @NotNull
    public static <K, V, I> TIntHashSet collectInputIdsContainingAllKeys(@NotNull InvertedIndex<? super K, V, I> index, @NotNull Collection<? extends K> dataKeys, @Nullable Condition<? super K> keyChecker, @Nullable Condition<? super V> valueChecker, @Nullable ValueContainer.IntPredicate idChecker) throws StorageException {
        TIntHashSet mainIntersection = null;
        for (K dataKey : dataKeys) {
            if (keyChecker != null && !keyChecker.value(dataKey)) continue;
            TIntHashSet copy = new TIntHashSet();
            ValueContainer<V> container = index.getData(dataKey);
            ValueContainer.ValueIterator<V> valueIt = container.getValueIterator();
            while (valueIt.hasNext()) {
                ValueContainer.IntPredicate predicate;
                Object value = valueIt.next();
                if (valueChecker != null && !valueChecker.value(value)) continue;
                ValueContainer.IntIterator iterator = valueIt.getInputIdsIterator();
                if (mainIntersection == null || iterator.size() < mainIntersection.size() || (predicate = valueIt.getValueAssociationPredicate()) == null) {
                    while (iterator.hasNext()) {
                        int id2 = iterator.next();
                        if ((mainIntersection != null || idChecker != null && !idChecker.contains(id2)) && (mainIntersection == null || !mainIntersection.contains(id2))) continue;
                        copy.add(id2);
                    }
                    continue;
                }
                mainIntersection.forEach(id -> {
                    if (predicate.contains(id)) {
                        copy.add(id);
                    }
                    return true;
                });
            }
            mainIntersection = copy;
            if (!mainIntersection.isEmpty()) continue;
            return EmptyIntHashSet.INSTANCE;
        }
        return mainIntersection == null ? EmptyIntHashSet.INSTANCE : mainIntersection;
    }
}

