/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.counters;

import com.android.tools.analytics.Counter;
import com.android.tools.analytics.Counters;
import com.google.wireless.android.sdk.stats.IntellijIndexingStats;
import org.jetbrains.annotations.NotNull;

public class IndexCounters {
    private static final String ID_INDEX_NAME = "IdIndex";
    private static final String STUBS_INDEX_NAME = "Stubs";
    private static final String TRIGRAM_INDEX_NAME = "Trigram.Index";
    public static final IndexCounters idIndexCounters = new IndexCounters("IdIndex", IntellijIndexingStats.Index.ID_INDEX);
    public static final IndexCounters stubIndexCounters = new IndexCounters("Stubs", IntellijIndexingStats.Index.STUB_INDEX);
    public static final IndexCounters trigramIndexCounters = new IndexCounters("Trigram.Index", IntellijIndexingStats.Index.TRIGRAM_INDEX);
    public static final IndexCounters otherIndexesCounters = new IndexCounters("Other", IntellijIndexingStats.Index.OTHER);
    @NotNull
    private final String myIndexName;
    @NotNull
    private final IntellijIndexingStats.Index myStatId;
    @NotNull
    private final Counter myMapInputCounter;
    @NotNull
    private final Counter myWriteLockCounter;
    @NotNull
    private final Counter myUpdateCounter;
    @NotNull
    private final Counter myGetDataCounter;

    @NotNull
    public static IndexCounters getIndexCounters(@NotNull String indexName) {
        switch (indexName) {
            case "IdIndex": {
                return idIndexCounters;
            }
            case "Stubs": {
                return stubIndexCounters;
            }
            case "Trigram.Index": {
                return trigramIndexCounters;
            }
        }
        return otherIndexesCounters;
    }

    @NotNull
    public static IntellijIndexingStats.Builder addAllIndexCountersAndReset(@NotNull IntellijIndexingStats.Builder builder) {
        builder.addIndexStats(idIndexCounters.toProto());
        builder.addIndexStats(stubIndexCounters.toProto());
        builder.addIndexStats(trigramIndexCounters.toProto());
        builder.addIndexStats(otherIndexesCounters.toProto());
        IndexCounters.reset();
        return builder;
    }

    private static void reset() {
        idIndexCounters.resetCounter();
        stubIndexCounters.resetCounter();
        trigramIndexCounters.resetCounter();
        otherIndexesCounters.resetCounter();
    }

    private IndexCounters(@NotNull String indexName, @NotNull IntellijIndexingStats.Index statId) {
        this.myIndexName = indexName;
        this.myStatId = statId;
        this.myMapInputCounter = Counters.get((String)("indexing/mapInput/" + indexName));
        this.myWriteLockCounter = Counters.get((String)("indexing/writeLock/" + indexName));
        this.myUpdateCounter = Counters.get((String)("indexing/Update/" + indexName));
        this.myGetDataCounter = Counters.get((String)("indexing/getData/" + indexName));
    }

    @NotNull
    public String getIndexName() {
        return this.myIndexName;
    }

    @NotNull
    public Counter getMapInputCounter() {
        return this.myMapInputCounter;
    }

    @NotNull
    public Counter getWriteLockCounter() {
        return this.myWriteLockCounter;
    }

    @NotNull
    public Counter getUpdateCounter() {
        return this.myUpdateCounter;
    }

    @NotNull
    public Counter getGetDataCounter() {
        return this.myGetDataCounter;
    }

    private void resetCounter() {
        this.myMapInputCounter.reset();
        this.myWriteLockCounter.reset();
        this.myUpdateCounter.reset();
        this.myGetDataCounter.reset();
    }

    @NotNull
    private IntellijIndexingStats.OperationStats toProto(@NotNull Counter counter, @NotNull IntellijIndexingStats.Operation operation) {
        return IntellijIndexingStats.OperationStats.newBuilder().setOperation(operation).setTotalCount(counter.getTotalCount()).setTotalWallNanos(counter.getTotalWallNanos()).setMaxWallNanos((int)counter.getMaxWallNanos()).build();
    }

    @NotNull
    private IntellijIndexingStats.IndexStats toProto() {
        return IntellijIndexingStats.IndexStats.newBuilder().setIndex(this.myStatId).addOperationStats(this.toProto(this.myMapInputCounter, IntellijIndexingStats.Operation.MAP_INPUT)).addOperationStats(this.toProto(this.myWriteLockCounter, IntellijIndexingStats.Operation.WRITE_LOCK)).addOperationStats(this.toProto(this.myUpdateCounter, IntellijIndexingStats.Operation.UPDATE_DATA)).addOperationStats(this.toProto(this.myGetDataCounter, IntellijIndexingStats.Operation.GET_DATA)).build();
    }
}

