/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CollectionInputDataDiffBuilder<Key, Value>
extends InputDataDiffBuilder<Key, Value> {
    private final Collection<Key> mySeq;

    public CollectionInputDataDiffBuilder(int inputId, @Nullable Collection<Key> seq) {
        super(inputId);
        this.mySeq = seq == null ? Collections.emptySet() : seq;
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        return CollectionInputDataDiffBuilder.differentiateWithKeySeq(this.mySeq, newData, this.myInputId, addProcessor, removeProcessor);
    }

    public Collection<Key> getSeq() {
        return this.mySeq;
    }

    static <Key, Value> boolean differentiateWithKeySeq(@NotNull Collection<? extends Key> currentData, @NotNull Map<Key, Value> newData, int inputId, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        for (Key key : currentData) {
            removeProcessor.process(key, inputId);
        }
        EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, inputId);
        return true;
    }
}

