/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.ValueContainerMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.PersistentMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MapIndexStorage<Key, Value>
implements IndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(MapIndexStorage.class);
    protected PersistentMap<Key, UpdatableValueContainer<Value>> myMap;
    protected SLRUCache<Key, ChangeTrackingValueContainer<Value>> myCache;
    protected final File myBaseStorageFile;
    protected final KeyDescriptor<Key> myKeyDescriptor;
    private final int myCacheSize;
    protected final Lock l = new ReentrantLock();
    private final DataExternalizer<Value> myDataExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;
    private final boolean myReadOnly;

    protected MapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile) throws IOException {
        this(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, true, false);
    }

    protected MapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean initialize, boolean readOnly) throws IOException {
        this.myBaseStorageFile = storageFile;
        this.myKeyDescriptor = keyDescriptor;
        this.myCacheSize = cacheSize;
        this.myDataExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
        this.myReadOnly = readOnly;
        if (initialize) {
            this.initMapAndCache();
        }
    }

    protected void initMapAndCache() throws IOException {
        ValueContainerMap map;
        PersistentHashMapValueStorage.CreationTimeOptions.EXCEPTIONAL_IO_CANCELLATION.set(new PersistentHashMapValueStorage.ExceptionalIOCancellationCallback(){

            @Override
            public void checkCancellation() {
                MapIndexStorage.this.checkCanceled();
            }
        });
        PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(Boolean.TRUE);
        if (this.myKeyIsUniqueForIndexedFile) {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.TRUE);
        }
        try {
            map = new ValueContainerMap<Key, Value>(this.getStorageFile(), this.myKeyDescriptor, this.myDataExternalizer, this.myKeyIsUniqueForIndexedFile){

                @Override
                protected boolean isReadOnly() {
                    return MapIndexStorage.this.myReadOnly;
                }
            };
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.EXCEPTIONAL_IO_CANCELLATION.set(null);
            PersistentHashMapValueStorage.CreationTimeOptions.COMPACT_CHUNKS_WITH_VALUE_DESERIALIZATION.set(null);
            if (this.myKeyIsUniqueForIndexedFile) {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.FALSE);
            }
        }
        this.myCache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(this.myCacheSize, (int)Math.ceil((double)this.myCacheSize * 0.25), this.myKeyDescriptor){

            @Override
            @NotNull
            public ChangeTrackingValueContainer<Value> createValue(final Key key) {
                return new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                    @Override
                    @NotNull
                    public Object getLock() {
                        return map.getDataAccessLock();
                    }

                    @Override
                    @Nullable
                    public ValueContainer<Value> compute() {
                        ValueContainerImpl value;
                        try {
                            value = (ValueContainerImpl)map.get(key);
                            if (value == null) {
                                value = new ValueContainerImpl();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return value;
                    }
                });
            }

            @Override
            protected void onDropFromCache(Key key, @NotNull ChangeTrackingValueContainer<Value> valueContainer) {
                if (!MapIndexStorage.this.myReadOnly && valueContainer.isDirty()) {
                    try {
                        map.put(key, valueContainer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.myMap = map;
    }

    protected abstract void checkCanceled();

    @NotNull
    private File getStorageFile() {
        return MapIndexStorage.getIndexStorageFile(this.myBaseStorageFile);
    }

    @Override
    public void flush() {
        this.l.lock();
        try {
            if (!this.myMap.isClosed()) {
                this.myCache.clear();
                if (this.myMap.isDirty()) {
                    this.myMap.force();
                }
            }
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void close() throws StorageException {
        try {
            this.flush();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.myMap.close();
        }
        catch (IOException | RuntimeException e) {
            LOG.error(e);
        }
        try {
            IOUtil.deleteAllFilesStartingWith(this.getStorageFile());
            this.initMapAndCache();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ChangeTrackingValueContainer<Value> read(Key key) throws StorageException {
        this.l.lock();
        try {
            ChangeTrackingValueContainer<Value> changeTrackingValueContainer = this.myCache.get(key);
            return changeTrackingValueContainer;
        }
        catch (RuntimeException e) {
            ChangeTrackingValueContainer changeTrackingValueContainer = (ChangeTrackingValueContainer)MapIndexStorage.unwrapCauseAndRethrow(e);
            return changeTrackingValueContainer;
        }
        finally {
            this.l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myReadOnly) {
            throw new IncorrectOperationException("Index storage is read-only");
        }
        try {
            ChangeTrackingValueContainer<Value> cached;
            this.myMap.markDirty();
            if (!this.myKeyIsUniqueForIndexedFile) {
                ((ChangeTrackingValueContainer)this.read((Object)key)).addValue(inputId, value);
                return;
            }
            try {
                this.l.lock();
                cached = this.myCache.getIfCached(key);
            }
            finally {
                this.l.unlock();
            }
            if (cached != null) {
                cached.addValue(inputId, value);
                return;
            }
            ChangeTrackingValueContainer<Value> valueContainer = new ChangeTrackingValueContainer<Value>(null);
            valueContainer.addValue(inputId, value);
            this.myMap.put(key, valueContainer);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        try {
            this.myMap.markDirty();
            ((ChangeTrackingValueContainer)this.read((Object)key)).removeAssociatedValue(inputId);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void clearCaches() {
        this.l.lock();
        try {
            for (Map.Entry entry : this.myCache.entrySet()) {
                ((ChangeTrackingValueContainer)entry.getValue()).dropMergedData();
            }
        }
        finally {
            this.l.unlock();
        }
    }

    protected static <T> T unwrapCauseAndRethrow(RuntimeException e) throws StorageException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw new StorageException(cause);
        }
        if (cause instanceof StorageException) {
            throw (StorageException)cause;
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processKeys(@NotNull Processor<? super Key> processor) throws StorageException {
        this.l.lock();
        try {
            this.myCache.clear();
            boolean bl = this.myMap.processKeys(processor);
            return bl;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            MapIndexStorage.unwrapCauseAndRethrow(e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    public PersistentMap<Key, UpdatableValueContainer<Value>> getIndexMap() {
        return this.myMap;
    }

    @NotNull
    public static File getIndexStorageFile(@NotNull File baseFile) {
        return new File(baseFile.getPath() + ".storage");
    }
}

