/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.counters.IndexCounters;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.indexing.impl.MapReduceIndex");
    @NotNull
    protected final IndexId<Key, Value> myIndexId;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    @NotNull
    private final IndexCounters myIndexCounters;
    protected final DataExternalizer<Value> myValueExternalizer;
    protected final IndexExtension<Key, Value, Input> myExtension;
    private final AtomicLong myModificationStamp = new AtomicLong();
    private final DataIndexer<Key, Value, Input> myIndexer;
    protected final ForwardIndex<Key, Value> myForwardIndex;
    private final ReentrantReadWriteLock myLock = this.createLock();
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher = LowMemoryWatcher.register(new Runnable(){

        @Override
        public void run() {
            try {
                MapReduceIndex.this.getReadLock().lock();
                try {
                    MapReduceIndex.this.myStorage.clearCaches();
                }
                finally {
                    MapReduceIndex.this.getReadLock().unlock();
                }
                MapReduceIndex.this.flush();
            }
            catch (Throwable e) {
                MapReduceIndex.this.requestRebuild(e);
            }
        }
    });
    private final RemovedKeyProcessor<Key> myRemovedKeyProcessor = new RemovedKeyProcessor<Key>(){

        @Override
        public void process(Key key, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.addValue(key, inputId, value);
        }
    };
    private final KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor = new KeyValueUpdateProcessor<Key, Value>(){

        @Override
        public void process(Key key, Value value, int inputId) throws StorageException {
            MapReduceIndex.this.myModificationStamp.incrementAndGet();
            MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            MapReduceIndex.this.myStorage.addValue(key, inputId, value);
        }
    };

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex<Key, Value> forwardIndex) {
        this.myIndexId = extension.getName();
        this.myIndexCounters = IndexCounters.getIndexCounters(this.myIndexId.getName());
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage;
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myForwardIndex = forwardIndex;
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        return this.myStorage;
    }

    @NotNull
    protected ReentrantReadWriteLock createLock() {
        return new ReentrantReadWriteLock();
    }

    @NotNull
    public final ReentrantReadWriteLock getLock() {
        return this.myLock;
    }

    @Override
    public void clear() {
        try {
            this.getWriteLock().lock();
            this.doClear();
        }
        catch (StorageException | IOException e) {
            LOG.error(e);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void doClear() throws StorageException, IOException {
        this.myStorage.clear();
        if (this.myForwardIndex != null) {
            this.myForwardIndex.clear();
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            this.doFlush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    protected void doFlush() throws IOException, StorageException {
        if (this.myForwardIndex != null) {
            this.myForwardIndex.flush();
        }
        this.myStorage.flush();
    }

    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            this.doDispose();
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myDisposed = true;
            lock.unlock();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            this.myStorage.close();
        }
        finally {
            try {
                if (this.myForwardIndex != null) {
                    this.myForwardIndex.close();
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public final Lock getReadLock() {
        return this.myLock.readLock();
    }

    @NotNull
    public final Lock getWriteLock() {
        return this.myLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        Lock lock = this.getReadLock();
        try {
            lock.lock();
            if (this.myDisposed) {
                ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
                return valueContainerImpl;
            }
            ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
            ValueContainer<Value> valueContainer = this.myStorage.read(key);
            return valueContainer;
        }
        finally {
            ValueContainerImpl.ourDebugIndexInfo.set(null);
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public final Computable<Boolean> update(int inputId, @Nullable Input content) {
        UpdateData updateData = (UpdateData)this.myIndexCounters.getMapInputCounter().timeCallable(() -> this.calculateUpdateData(inputId, content));
        return () -> (Boolean)this.myIndexCounters.getUpdateCounter().timeCallable(() -> {
            try {
                this.updateWithMap(inputId, updateData);
            }
            catch (ProcessCanceledException | StorageException ex) {
                LOG.info("Exception during updateWithMap:" + ex);
                this.requestRebuild(ex);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(final int inputId, @Nullable Input content) {
        final Map<Key, Value> data = this.mapInput(content);
        return this.createUpdateData(data, new ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException>(){

            @Override
            public InputDataDiffBuilder<Key, Value> compute() throws IOException {
                return MapReduceIndex.this.getKeysDiffBuilder(inputId);
            }
        }, new ThrowableRunnable<IOException>(){

            @Override
            public void run() throws IOException {
                if (MapReduceIndex.this.myForwardIndex != null) {
                    MapReduceIndex.this.myForwardIndex.putInputData(inputId, data);
                }
            }
        });
    }

    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.myForwardIndex != null) {
            return this.myForwardIndex.getDiffBuilder(inputId);
        }
        return new EmptyInputDataDiffBuilder(inputId);
    }

    @NotNull
    protected UpdateData<Key, Value> createUpdateData(@NotNull Map<Key, Value> data, @NotNull ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> keys, @NotNull ThrowableRunnable<IOException> forwardIndexUpdate) {
        return new UpdateData<Key, Value>(data, keys, this.myIndexId, forwardIndexUpdate);
    }

    @NotNull
    protected Map<Key, Value> mapInput(@Nullable Input content) {
        if (content == null) {
            return Collections.emptyMap();
        }
        Map<Key, Value> data = this.myIndexer.map(content);
        MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data, this.myIndexId, this.myValueExternalizer);
        this.checkCanceled();
        return data;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(@NotNull Throwable var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, @NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (!this.getWriteLock().tryLock()) {
            this.myIndexCounters.getWriteLockCounter().timeRunnable(() -> this.getWriteLock().lock());
        }
        try {
            try {
                ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
                boolean hasDifference = updateData.iterateKeys(this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                if (hasDifference) {
                    updateData.updateForwardIndex();
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                ValueContainerImpl.ourDebugIndexInfo.set(null);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public void removeTransientDataForFile(int inputId) {
    }

    public static <Key, Value> void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<Key, Value> data, @NotNull IndexId<Key, Value> indexId, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (DebugAssertions.DEBUG) {
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                Value value = e.getValue();
                if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                    LOG.error("Index " + indexId + " violates equals / hashCode contract for Value parameter");
                }
                try {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream = new DataOutputStream(out);
                    valueExternalizer.save(outputStream, value);
                    outputStream.close();
                    Value deserializedValue = valueExternalizer.read(new DataInputStream(out.toInputStream()));
                    if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                    LOG.error("Index " + indexId + " deserialization violates equals / hashCode contract for Value parameter");
                }
                catch (IOException ex) {
                    LOG.error(ex);
                }
            }
        }
    }
}

