/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class UpdateData<Key, Value> {
    private final Map<Key, Value> myNewData;
    private final ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> myCurrentDataEvaluator;
    private final IndexId<Key, Value> myIndexId;
    private final ThrowableRunnable<? extends IOException> myForwardIndexUpdate;

    public UpdateData(@NotNull Map<Key, Value> newData, @NotNull ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> currentDataEvaluator, @NotNull IndexId<Key, Value> indexId, @Nullable ThrowableRunnable<? extends IOException> forwardIndexUpdate) {
        this.myNewData = newData;
        this.myCurrentDataEvaluator = currentDataEvaluator;
        this.myIndexId = indexId;
        this.myForwardIndexUpdate = forwardIndexUpdate;
    }

    boolean iterateKeys(@NotNull KeyValueUpdateProcessor<Key, Value> addProcessor, @NotNull KeyValueUpdateProcessor<Key, Value> updateProcessor, @NotNull RemovedKeyProcessor<Key> removeProcessor) throws StorageException {
        InputDataDiffBuilder<Key, Value> currentData;
        try {
            currentData = this.getCurrentDataEvaluator().compute();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        return currentData.differentiate(this.myNewData, addProcessor, updateProcessor, removeProcessor);
    }

    @NotNull
    protected ThrowableComputable<InputDataDiffBuilder<Key, Value>, IOException> getCurrentDataEvaluator() {
        return this.myCurrentDataEvaluator;
    }

    @NotNull
    protected Map<Key, Value> getNewData() {
        return this.myNewData;
    }

    @NotNull
    public IndexId<Key, Value> getIndexId() {
        return this.myIndexId;
    }

    void updateForwardIndex() throws IOException {
        if (this.myForwardIndexUpdate != null) {
            this.myForwardIndexUpdate.run();
        }
    }

    public String toString() {
        return this.myIndexId + "," + this.getClass().getName();
    }
}

