/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class ValueContainerMap<Key, Value>
extends PersistentHashMap<Key, UpdatableValueContainer<Value>> {
    @NotNull
    private final DataExternalizer<Value> myValueExternalizer;
    private final boolean myKeyIsUniqueForIndexedFile;

    ValueContainerMap(@NotNull File file, @NotNull KeyDescriptor<Key> keyKeyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, boolean keyIsUniqueForIndexedFile) throws IOException {
        super(file, keyKeyDescriptor, new ValueContainerExternalizer(valueExternalizer));
        this.myValueExternalizer = valueExternalizer;
        this.myKeyIsUniqueForIndexedFile = keyIsUniqueForIndexedFile;
    }

    @NotNull
    Object getDataAccessLock() {
        return this.myEnumerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPut(Key key, UpdatableValueContainer<Value> container) throws IOException {
        PersistentEnumeratorBase persistentEnumeratorBase = this.myEnumerator;
        synchronized (persistentEnumeratorBase) {
            final ChangeTrackingValueContainer valueContainer = (ChangeTrackingValueContainer)container;
            if (!valueContainer.needsCompacting() && !this.myKeyIsUniqueForIndexedFile) {
                this.appendData(key, new PersistentHashMap.ValueDataAppender(){

                    @Override
                    public void append(@NotNull DataOutput out) throws IOException {
                        valueContainer.saveTo(out, ValueContainerMap.this.myValueExternalizer);
                    }
                });
            } else {
                super.doPut(key, valueContainer);
            }
        }
    }

    private static final class ValueContainerExternalizer<T>
    implements DataExternalizer<UpdatableValueContainer<T>> {
        @NotNull
        private final DataExternalizer<T> myValueExternalizer;

        private ValueContainerExternalizer(@NotNull DataExternalizer<T> valueExternalizer) {
            this.myValueExternalizer = valueExternalizer;
        }

        @Override
        public void save(@NotNull DataOutput out, @NotNull UpdatableValueContainer<T> container) throws IOException {
            container.saveTo(out, this.myValueExternalizer);
        }

        @Override
        @NotNull
        public UpdatableValueContainer<T> read(@NotNull DataInput in) throws IOException {
            ValueContainerImpl<T> valueContainer = new ValueContainerImpl<T>();
            valueContainer.readFrom((DataInputStream)in, this.myValueExternalizer);
            return valueContainer;
        }
    }
}

