/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.FileChunkKey;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import gnu.trove.TLongArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CompressedAppendableFile {
    private final File myBaseFile;
    private final LowMemoryWatcher myLowMemoryWatcher;
    private byte[] myNextChunkBuffer;
    private int myBufferPosition;
    private boolean myDirty;
    private short[] myChunkLengthTable;
    private int myChunkTableLength;
    private static final int FACTOR = 32;
    private long[] myChunkOffsetTable;
    private static final boolean doDebug = SystemProperties.getBooleanProperty("idea.compressed.file.self.check", false);
    private final TLongArrayList myCompressedChunksFileOffsets = doDebug ? new TLongArrayList() : null;
    public static final int PAGE_LENGTH = SystemProperties.getIntProperty("idea.compressed.file.page.length", 32768);
    private static final int MAX_PAGE_LENGTH = 65535;
    private long myFileLength;
    private long myUncompressedFileLength = -1L;
    private final int myAppendBufferLength;
    private static final int myMinAppendBufferLength = 1024;
    static final String INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION = ".s";
    private static int ourFilesCount;
    private final int myCount = ourFilesCount++;
    private static final FileChunkReadCache ourDecompressedCache;

    public CompressedAppendableFile(File file) {
        this(file, 32768);
    }

    private CompressedAppendableFile(File file, int bufferSize) {
        this.myBaseFile = file;
        this.myAppendBufferLength = bufferSize;
        assert (bufferSize <= 65535);
        file.getParentFile().mkdirs();
        this.myLowMemoryWatcher = LowMemoryWatcher.register(() -> {
            this.dropCaches();
            FileChunkReadCache fileChunkReadCache = ourDecompressedCache;
            synchronized (fileChunkReadCache) {
                ourDecompressedCache.clear();
            }
        });
    }

    public synchronized <Data> Data read(long addr, KeyDescriptor<Data> descriptor) throws IOException {
        try (DataInputStream stream = this.getStream(addr);){
            Object t = descriptor.read(stream);
            return (Data)t;
        }
    }

    @NotNull
    public synchronized DataInputStream getStream(long addr) throws IOException {
        this.initChunkLengthTable();
        this.loadAppendBuffer();
        return new DataInputStream(new SegmentedChunkInputStream(addr, this.myChunkTableLength, this.myNextChunkBuffer, this.myBufferPosition));
    }

    protected File getChunkLengthFile() {
        return new File(this.myBaseFile.getPath() + INCOMPLETE_CHUNK_LENGTH_FILE_EXTENSION);
    }

    private synchronized void initChunkLengthTable() throws IOException {
        if (this.myChunkLengthTable != null) {
            return;
        }
        File chunkLengthFile = this.getChunkLengthFile();
        if (chunkLengthFile.exists()) {
            try (DataInputStream chunkLengthStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(chunkLengthFile), (int)chunkLengthFile.length()){

                @Override
                public int available() {
                    return this.remainingLimit();
                }
            }, 32768));){
                short[] chunkLengthTable = new short[(int)(chunkLengthFile.length() / 2L)];
                int chunkLengthTableLength = 0;
                long o = 0L;
                while (chunkLengthStream.available() != 0) {
                    int chunkLength = DataInputOutputUtil.readINT(chunkLengthStream);
                    o += (long)chunkLength;
                    if (chunkLengthTableLength == chunkLengthTable.length) {
                        chunkLengthTable = CompressedAppendableFile.reallocShortTable(chunkLengthTable);
                    }
                    chunkLengthTable[chunkLengthTableLength++] = (short)chunkLength;
                    if (!doDebug) continue;
                    this.myCompressedChunksFileOffsets.add(o);
                }
                this.myChunkLengthTable = chunkLengthTable;
                this.myChunkTableLength = chunkLengthTableLength;
                if (this.myChunkTableLength >= 32) {
                    int i;
                    long[] chunkOffsetTable = new long[this.myChunkTableLength / 32];
                    long offset = 0L;
                    for (i = 0; i < chunkOffsetTable.length; ++i) {
                        int start = i * 32;
                        for (int j = 0; j < 32; ++j) {
                            offset += (long)(chunkLengthTable[start + j] & 0xFFFF);
                        }
                        chunkOffsetTable[i] = offset;
                    }
                    this.myChunkOffsetTable = chunkOffsetTable;
                    if (doDebug) {
                        for (i = 0; i < chunkLengthTableLength; ++i) {
                            this.calcOffsetOfPage(i);
                        }
                    }
                } else {
                    this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
                }
                this.myFileLength = this.calcOffsetOfPage(this.myChunkTableLength - 1);
            }
        } else {
            this.myChunkLengthTable = ArrayUtil.EMPTY_SHORT_ARRAY;
            this.myChunkTableLength = 0;
            this.myChunkOffsetTable = ArrayUtil.EMPTY_LONG_ARRAY;
            this.myFileLength = 0L;
        }
        if (this.myUncompressedFileLength == -1L) {
            long tempFileLength = this.getIncompleteChunkFile().length();
            this.myUncompressedFileLength = (long)this.myChunkTableLength * (long)this.myAppendBufferLength + tempFileLength;
            if (this.myUncompressedFileLength != this.myFileLength + tempFileLength && CompressionUtil.DUMP_COMPRESSION_STATS) {
                System.out.println(this.myUncompressedFileLength + "->" + (this.myFileLength + tempFileLength) + " for " + this.myBaseFile);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private synchronized byte[] loadChunk(int chunkNumber) throws IOException {
        try {
            if (this.myChunkLengthTable == null) {
                this.initChunkLengthTable();
            }
            assert (chunkNumber < this.myChunkTableLength);
            try (DataInputStream keysStream = this.getChunkStream(this.getChunksFile(), chunkNumber);){
                if (keysStream.available() > 0) {
                    byte[] decompressedBytes = this.decompress(keysStream);
                    if (decompressedBytes.length != this.myAppendBufferLength) assert (false);
                    byte[] byArray = decompressedBytes;
                    return byArray;
                }
            }
            assert (false) : "data corruption detected:" + chunkNumber + "," + this.myChunkTableLength;
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        catch (AssertionError | RuntimeException e) {
            throw new IOException((Throwable)e);
        }
    }

    @NotNull
    private DataInputStream getChunkStream(File appendFile, int pageNumber) throws IOException {
        int limit;
        long pageStartOffset;
        long pageEndOffset;
        assert (this.myFileLength != 0L);
        long l = pageEndOffset = pageNumber < this.myChunkTableLength ? this.calcOffsetOfPage(pageNumber) : this.myFileLength;
        if (pageNumber > 0) {
            pageStartOffset = this.calcOffsetOfPage(pageNumber - 1);
            limit = (int)(pageEndOffset - pageStartOffset);
        } else {
            pageStartOffset = 0L;
            limit = (int)pageEndOffset;
        }
        return new DataInputStream(this.getChunkInputStream(appendFile, pageStartOffset, limit));
    }

    private long calcOffsetOfPage(int pageNumber) {
        int calculatedOffset = (pageNumber + 1) / 32;
        long offset = calculatedOffset > 0 ? this.myChunkOffsetTable[calculatedOffset - 1] : 0L;
        int baseOffset = calculatedOffset * 32;
        int len = (pageNumber + 1) % 32;
        for (int index = 0; index < len; ++index) {
            offset += (long)(this.myChunkLengthTable[baseOffset + index] & 0xFFFF);
        }
        if (doDebug) assert (this.myCompressedChunksFileOffsets.get(pageNumber) == offset);
        return offset;
    }

    @NotNull
    protected InputStream getChunkInputStream(File appendFile, long offset, int pageSize) throws IOException {
        FileInputStream in = new FileInputStream(appendFile);
        if (offset > 0L) {
            in.skip(offset);
        }
        return new BufferedInputStream(new LimitedInputStream(in, pageSize){

            @Override
            public int available() {
                return this.remainingLimit();
            }
        }, pageSize);
    }

    public synchronized <Data> void append(Data value, KeyDescriptor<Data> descriptor) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        this.append(buffer, size);
    }

    public void append(byte[] buffer, int size) throws IOException {
        this.append(buffer, 0, size);
    }

    public synchronized void append(byte[] buffer, int offset, int size) throws IOException {
        int bytesToWriteInTheBuffer;
        int newBufferSize;
        if (size == 0) {
            return;
        }
        if (this.myNextChunkBuffer == null) {
            this.loadAppendBuffer();
        }
        if (this.myNextChunkBuffer.length != this.myAppendBufferLength && this.myBufferPosition + size >= this.myNextChunkBuffer.length && (newBufferSize = this.calcBufferSize(this.myBufferPosition + size)) != this.myNextChunkBuffer.length) {
            this.myNextChunkBuffer = Arrays.copyOf(this.myNextChunkBuffer, newBufferSize);
        }
        int bufferPosition = offset;
        for (int sizeToWrite = size; sizeToWrite > 0; sizeToWrite -= bytesToWriteInTheBuffer) {
            bytesToWriteInTheBuffer = Math.min(this.myNextChunkBuffer.length - this.myBufferPosition, sizeToWrite);
            System.arraycopy(buffer, bufferPosition, this.myNextChunkBuffer, this.myBufferPosition, bytesToWriteInTheBuffer);
            this.myBufferPosition += bytesToWriteInTheBuffer;
            bufferPosition += bytesToWriteInTheBuffer;
            this.saveNextChunkIfNeeded();
        }
        if (this.myUncompressedFileLength == -1L) {
            this.length();
        }
        this.myUncompressedFileLength += (long)size;
        this.myDirty = true;
    }

    private synchronized void loadAppendBuffer() throws IOException {
        if (this.myNextChunkBuffer != null) {
            return;
        }
        File tempAppendFile = this.getIncompleteChunkFile();
        if (tempAppendFile.exists()) {
            this.myBufferPosition = (int)tempAppendFile.length();
            this.myNextChunkBuffer = new byte[this.calcBufferSize(this.myBufferPosition)];
            try (FileInputStream stream = new FileInputStream(tempAppendFile);){
                stream.read(this.myNextChunkBuffer, 0, this.myBufferPosition);
            }
        } else {
            this.myBufferPosition = 0;
            this.myNextChunkBuffer = new byte[1024];
        }
    }

    private int calcBufferSize(int position) {
        return Math.min(this.myAppendBufferLength, Integer.highestOneBit(Math.max(1023, position)) << 1);
    }

    private void saveNextChunkIfNeeded() throws IOException {
        if (this.myBufferPosition == this.myNextChunkBuffer.length) {
            BufferExposingByteArrayOutputStream compressedOut = new BufferExposingByteArrayOutputStream();
            DataOutputStream compressedDataOut = new DataOutputStream(compressedOut);
            this.compress(compressedDataOut, this.myNextChunkBuffer);
            compressedDataOut.close();
            assert (compressedDataOut.size() <= 65535);
            this.saveChunk(compressedOut, this.myFileLength);
            this.myBufferPosition = 0;
            this.initChunkLengthTable();
            this.myFileLength += (long)compressedOut.size();
            if (doDebug) {
                this.myCompressedChunksFileOffsets.add(this.myFileLength);
            }
            if (this.myChunkLengthTable.length == this.myChunkTableLength) {
                this.myChunkLengthTable = CompressedAppendableFile.reallocShortTable(this.myChunkLengthTable);
            }
            this.myChunkLengthTable[this.myChunkTableLength++] = (short)compressedOut.size();
            if (this.myChunkTableLength / 32 > this.myChunkOffsetTable.length) {
                long[] newChunkOffsetTable = new long[this.myChunkOffsetTable.length + 1];
                System.arraycopy(this.myChunkOffsetTable, 0, newChunkOffsetTable, 0, this.myChunkOffsetTable.length);
                newChunkOffsetTable[this.myChunkOffsetTable.length] = this.myFileLength;
                this.myChunkOffsetTable = newChunkOffsetTable;
            }
            byte[] bytes = new byte[this.myAppendBufferLength];
            System.arraycopy(this.myNextChunkBuffer, 0, bytes, 0, this.myAppendBufferLength);
            ourDecompressedCache.put(this, this.myChunkTableLength - 1, bytes);
        }
    }

    @NotNull
    private static short[] reallocShortTable(short[] table) {
        short[] newTable = new short[Math.max(table.length * 8 / 5, table.length + 1)];
        System.arraycopy(table, 0, newTable, 0, table.length);
        return newTable;
    }

    protected int compress(DataOutputStream compressedDataOut, byte[] buffer) throws IOException {
        return CompressionUtil.writeCompressedWithoutOriginalBufferLength(compressedDataOut, buffer, this.myAppendBufferLength);
    }

    @NotNull
    protected byte[] decompress(DataInputStream keysStream) throws IOException {
        return CompressionUtil.readCompressedWithoutOriginalBufferLength(keysStream, this.myAppendBufferLength);
    }

    protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunksFile(), true)));){
            stream.write(compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
        }
        var5_4 = null;
        try (DataOutputStream chunkLengthStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));){
            DataInputOutputUtil.writeINT(chunkLengthStream, compressedChunk.size());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    @NotNull
    protected File getChunksFile() {
        return new File(this.myBaseFile.getPath() + ".a");
    }

    private void saveIncompleteChunk() {
        if (this.myNextChunkBuffer != null && this.myDirty) {
            block19: {
                File incompleteChunkFile = this.getIncompleteChunkFile();
                try {
                    this.saveNextChunkIfNeeded();
                    if (this.myBufferPosition != 0) {
                        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(incompleteChunkFile));){
                            stream.write(this.myNextChunkBuffer, 0, this.myBufferPosition);
                            break block19;
                        }
                    }
                    incompleteChunkFile.delete();
                }
                catch (FileNotFoundException ex) {
                    File parentFile = incompleteChunkFile.getParentFile();
                    if (!parentFile.exists()) {
                        if (parentFile.mkdirs()) {
                            this.saveIncompleteChunk();
                            return;
                        }
                        throw new RuntimeException("Failed to write:" + incompleteChunkFile, ex);
                    }
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.myDirty = false;
        }
    }

    @NotNull
    private File getIncompleteChunkFile() {
        return new File(this.myBaseFile.getPath() + ".at");
    }

    public synchronized void dropCaches() {
    }

    public synchronized void force() {
        this.saveIncompleteChunk();
    }

    public synchronized void dispose() {
        this.force();
        this.myLowMemoryWatcher.stop();
    }

    public synchronized long length() {
        if (this.myUncompressedFileLength == -1L && this.myChunkLengthTable == null) {
            try {
                this.initChunkLengthTable();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.myUncompressedFileLength;
    }

    public synchronized boolean isDirty() {
        return this.myDirty;
    }

    public int hashCode() {
        return this.myCount;
    }

    static {
        ourDecompressedCache = new FileChunkReadCache();
    }

    private class SegmentedChunkInputStream
    extends InputStream {
        private final long myAddr;
        private final int myChunkLengthTableSnapshotLength;
        private final byte[] myNextChunkBufferSnapshot;
        private final int myBufferPositionSnapshot;
        private InputStream bytesFromCompressedBlock;
        private InputStream bytesFromTempAppendBlock;
        private int myCurrentPageNumber;
        private int myPageOffset;

        SegmentedChunkInputStream(long addr, int chunkLengthTableSnapshotLength, byte[] tableRef, int position) {
            this.myAddr = addr;
            this.myChunkLengthTableSnapshotLength = chunkLengthTableSnapshotLength;
            this.myNextChunkBufferSnapshot = tableRef;
            this.myBufferPositionSnapshot = position;
            this.myCurrentPageNumber = (int)(this.myAddr / (long)CompressedAppendableFile.this.myAppendBufferLength);
            this.myPageOffset = (int)(this.myAddr % (long)CompressedAppendableFile.this.myAppendBufferLength);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (this.bytesFromCompressedBlock == null) {
                byte[] decompressedBytes = this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength ? ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber) : ArrayUtil.EMPTY_BYTE_ARRAY;
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, this.myPageOffset, decompressedBytes.length);
            }
            int readBytesCount = 0;
            if (this.bytesFromCompressedBlock.available() > 0) {
                readBytesCount = this.bytesFromCompressedBlock.read(b, off, len);
                this.myPageOffset += readBytesCount;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if (readBytesCount == len) {
                    return readBytesCount;
                }
            }
            while (this.myCurrentPageNumber < this.myChunkLengthTableSnapshotLength) {
                byte[] decompressedBytes = ourDecompressedCache.get(CompressedAppendableFile.this, this.myCurrentPageNumber);
                this.bytesFromCompressedBlock = new ByteArrayInputStream(decompressedBytes, 0, decompressedBytes.length);
                int read = this.bytesFromCompressedBlock.read(b, off + readBytesCount, len - readBytesCount);
                this.myPageOffset += read;
                if (this.myPageOffset == CompressedAppendableFile.this.myAppendBufferLength) {
                    ++this.myCurrentPageNumber;
                    this.myPageOffset = 0;
                }
                if ((readBytesCount += read) != len) continue;
                return readBytesCount;
            }
            if (this.bytesFromTempAppendBlock == null) {
                this.bytesFromTempAppendBlock = new ByteArrayInputStream(this.myNextChunkBufferSnapshot, this.myPageOffset, this.myBufferPositionSnapshot);
            }
            return readBytesCount + this.bytesFromTempAppendBlock.read(b, off + readBytesCount, len - readBytesCount);
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[]{0};
            int read = this.read(buf);
            if (read == -1) {
                return -1;
            }
            return buf[0] & 0xFF;
        }
    }

    private static class FileChunkReadCache
    extends SLRUMap<FileChunkKey<CompressedAppendableFile>, byte[]> {
        private final FileChunkKey<CompressedAppendableFile> myKey = new FileChunkKey<Object>(null, 0L);

        FileChunkReadCache() {
            super(64, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public byte[] get(CompressedAppendableFile file, int page) throws IOException {
            byte[] bytes;
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file, page);
                bytes = (byte[])this.get(this.myKey);
                if (bytes != null) {
                    return bytes;
                }
            }
            bytes = file.loadChunk(page);
            fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.put(file, page, bytes);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(CompressedAppendableFile file, long page, byte[] bytes) {
            FileChunkReadCache fileChunkReadCache = this;
            synchronized (fileChunkReadCache) {
                this.myKey.setup(file, page);
                this.put(this.myKey, bytes);
            }
        }
    }
}

