/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(@NotNull String name) {
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, @NotNull AbstractStringEnumerator store) {
        this.id = id;
        this.store = store;
    }

    public String getString() {
        String name = this.name;
        if (name == null) {
            try {
                this.name = name = (String)this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public void writeTo(@NotNull DataOutput out, @NotNull AbstractStringEnumerator store) throws IOException {
        int nameId = this.getId(store);
        out.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(out, nameId >> 8);
    }

    public int getId(@NotNull AbstractStringEnumerator store) {
        if (this.id == -1) {
            try {
                this.id = store.enumerate(this.name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    @Contract(value="null -> null")
    public static String toString(@Nullable StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static StringRef fromString(@Nullable String source) {
        return source == null ? null : new StringRef(source);
    }

    @NotNull
    public static StringRef fromNullableString(@Nullable String source) {
        return new StringRef(source == null ? "" : source);
    }

    @Nullable
    public static StringRef fromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store) throws IOException {
        int nameId = DataInputOutputUtil.readINT(in);
        return nameId != 0 ? new StringRef(nameId, store) : null;
    }

    @Nullable
    public static String stringFromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store) throws IOException {
        int nameId = DataInputOutputUtil.readINT(in);
        return nameId != 0 ? (String)store.valueOf(nameId) : null;
    }

    @NotNull
    public static StringRef[] createArray(int count) {
        return count == 0 ? EMPTY_ARRAY : new StringRef[count];
    }
}

