/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.ScheduledForRemoval(inVersion="2019.1")
public class TarUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.TarUtil");

    private TarUtil() {
    }

    @NotNull
    public static TarArchiveOutputStream getTarGzOutputStream(File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)fos);
        TarArchiveOutputStream zip = new TarArchiveOutputStream((OutputStream)gcos);
        zip.setLongFileMode(3);
        return zip;
    }

    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        return TarUtil.addFileToTar(tos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor) throws IOException {
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file.isDirectory();
        if (isDir) {
            return true;
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = file.length();
        TarArchiveEntry e = new TarArchiveEntry(relativeName);
        e.setModTime(file.lastModified());
        e.setSize(size);
        tos.putArchiveEntry((ArchiveEntry)e);
        try (InputStream is = contentProcessor.getContent(file);){
            FileUtil.copy(is, (OutputStream)tos);
        }
        tos.closeArchiveEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull TarArchiveOutputStream tarOutputStream, @Nullable File tarFile, @NotNull File file, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (file.isDirectory()) {
            return TarUtil.addDirToTarRecursively(tarOutputStream, tarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        TarUtil.addFileToTar(tarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
        return true;
    }

    public static boolean addDirToTarRecursively(@NotNull TarArchiveOutputStream outputStream, @Nullable File tarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (tarFile != null && FileUtil.isAncestor(dir, tarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            TarUtil.addFileToTar(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                TarUtil.addFileOrDirRecursively(outputStream, tarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

