/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.ZipUtil");

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        return ZipUtil.addFileToZip(zos, file, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, file.isDirectory());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, boolean isDir) throws IOException {
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file + " as " + relativeName);
        }
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            try (InputStream is = contentProcessor.getContent(file);){
                FileUtilRt.copy(is, zos);
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (file.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children;
        if (jarFile != null && FileUtil.isAncestor(dir, jarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, true);
        }
        if ((children = dir.listFiles()) != null) {
            for (File child : children) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filter) throws IOException {
        new Decompressor.Zip(file).filter(FileFilterAdapter.wrap(outputDir, filter)).extract(outputDir);
    }

    public static void extract(@NotNull File file, @NotNull File outputDir, @Nullable FilenameFilter filter, boolean overwrite) throws IOException {
        new Decompressor.Zip(file).filter(FileFilterAdapter.wrap(outputDir, filter)).overwrite(overwrite).extract(outputDir);
    }

    public static boolean isZipContainsFolder(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        try (FileInputStream is = new FileInputStream(srcFile);
             ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
            os.putNextEntry(new ZipEntry(srcFile.getName()));
            FileUtilRt.copy(is, os);
            os.closeEntry();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020")
    public static void extract(@NotNull ZipFile zip, @NotNull File outputDir, @Nullable FilenameFilter filter) throws IOException {
        new Decompressor.Zip(new File(zip.getName())).filter(FileFilterAdapter.wrap(outputDir, filter)).extract(outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020")
    public static void extractEntry(@NotNull ZipEntry entry, @NotNull InputStream inputStream, @NotNull File outputDir, boolean overwrite) throws IOException {
        block16: {
            File outputFile = Decompressor.entryFile(outputDir, entry.getName());
            try {
                if (entry.isDirectory()) {
                    FileUtil.createDirectory(outputFile);
                    break block16;
                }
                if (outputFile.exists() && !overwrite) break block16;
                FileUtil.createParentDirs(outputFile);
                try (FileOutputStream os = new FileOutputStream(outputFile);){
                    FileUtilRt.copy(inputStream, os);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    private static class FileFilterAdapter
    implements Condition<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(File outputDir, FilenameFilter filter) {
            return filter == null ? null : new FileFilterAdapter(outputDir, filter);
        }

        private FileFilterAdapter(File outputDir, FilenameFilter filter) {
            this.myOutputDir = outputDir;
            this.myFilter = filter;
        }

        @Override
        public boolean value(String entryName) {
            File outputFile = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile.getParentFile(), outputFile.getName());
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(@NotNull File file) throws IOException {
                return new FileInputStream(file);
            }
        };

        public InputStream getContent(@NotNull File var1) throws IOException;
    }
}

