/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import org.jetbrains.annotations.NotNull;

final class OneElementFMap
implements KeyFMap {
    private final Key myKey;
    private final Object myValue;

    <V> OneElementFMap(@NotNull Key<V> key, @NotNull V value) {
        this.myKey = key;
        this.myValue = value;
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (this.myKey == key) {
            return value == this.myValue ? this : new OneElementFMap(key, value);
        }
        return new PairElementsFMap(this.myKey, this.myValue, key, value);
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        return key == this.myKey ? KeyFMap.EMPTY_MAP : this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return (V)(this.myKey == key ? this.myValue : null);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return new Key[]{this.myKey};
    }

    public String toString() {
        return "{" + this.myKey + "=" + this.myValue + "}";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        return this.myKey.hashCode() * 31 + System.identityHashCode(this.myValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneElementFMap)) {
            return false;
        }
        OneElementFMap map = (OneElementFMap)o;
        return this.myKey == map.myKey && this.myValue.equals(map.myValue);
    }

    @Override
    public boolean equalsByReference(KeyFMap o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneElementFMap)) {
            return false;
        }
        OneElementFMap map = (OneElementFMap)o;
        return this.myKey == map.myKey && this.myValue == map.myValue;
    }

    public int hashCode() {
        return this.myKey.hashCode() ^ this.myValue.hashCode();
    }
}

