/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import org.jetbrains.annotations.NotNull;

final class PairElementsFMap
implements KeyFMap {
    @NotNull
    private final Key key1;
    @NotNull
    private final Key key2;
    @NotNull
    private final Object value1;
    @NotNull
    private final Object value2;

    PairElementsFMap(@NotNull Key key1, @NotNull Object value1, @NotNull Key key2, @NotNull Object value2) {
        assert (key1 != key2);
        if (key1.hashCode() < key2.hashCode()) {
            this.key1 = key1;
            this.value1 = value1;
            this.key2 = key2;
            this.value2 = value2;
        } else {
            this.key1 = key2;
            this.value1 = value2;
            this.key2 = key1;
            this.value2 = value1;
        }
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value) {
        if (key == this.key1) {
            return value == this.value1 ? this : new PairElementsFMap(key, value, this.key2, this.value2);
        }
        if (key == this.key2) {
            return value == this.value2 ? this : new PairElementsFMap(key, value, this.key1, this.value1);
        }
        if (key.hashCode() < this.key1.hashCode()) {
            return new ArrayBackedFMap(new int[]{key.hashCode(), this.key1.hashCode(), this.key2.hashCode()}, new Object[]{value, this.value1, this.value2});
        }
        if (key.hashCode() < this.key2.hashCode()) {
            return new ArrayBackedFMap(new int[]{this.key1.hashCode(), key.hashCode(), this.key2.hashCode()}, new Object[]{this.value1, value, this.value2});
        }
        return new ArrayBackedFMap(new int[]{this.key1.hashCode(), this.key2.hashCode(), key.hashCode()}, new Object[]{this.value1, this.value2, value});
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == this.key1) {
            return new OneElementFMap(this.key2, this.value2);
        }
        if (key == this.key2) {
            return new OneElementFMap(this.key1, this.value1);
        }
        return this;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        return (V)(key == this.key1 ? this.value1 : (key == this.key2 ? this.value2 : null));
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        return new Key[]{this.key1, this.key2};
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + ", " + this.key2 + "=" + this.value2 + "}";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getValueIdentityHashCode() {
        int hash = this.key1.hashCode() * 31 + System.identityHashCode(this.value1);
        hash = (hash * 31 + this.key2.hashCode()) * 31 + System.identityHashCode(this.value2);
        return hash;
    }

    public int hashCode() {
        return (this.key1.hashCode() ^ this.value1.hashCode()) + (this.key2.hashCode() ^ this.value2.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PairElementsFMap)) {
            return false;
        }
        PairElementsFMap map = (PairElementsFMap)o;
        return this.key1 == map.key1 && this.value1.equals(map.value1) && this.key2 == map.key2 && this.value2.equals(map.value2);
    }

    @Override
    public boolean equalsByReference(KeyFMap o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PairElementsFMap)) {
            return false;
        }
        PairElementsFMap map = (PairElementsFMap)o;
        return this.key1 == map.key1 && this.value1 == map.value1 && this.key2 == map.key2 && this.value2 == map.value2;
    }
}

