/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.loader;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class NativeLibraryLoader {
    public static void loadPlatformLibrary(@NotNull String libName) {
        String libPath;
        String libFileName = NativeLibraryLoader.mapLibraryName(libName);
        File libFile = PathManager.findBinFile(libFileName);
        if (libFile != null) {
            libPath = libFile.getAbsolutePath();
        } else {
            libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName;
            if (!new File(libPath).exists()) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    @NotNull
    private static String mapLibraryName(@NotNull String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }
}

