/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Topic<L> {
    private final String myDisplayName;
    private final Class<L> myListenerClass;
    private final BroadcastDirection myBroadcastDirection;

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        this(displayName, listenerClass, BroadcastDirection.TO_CHILDREN);
    }

    public Topic(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, @NotNull BroadcastDirection broadcastDirection) {
        this.myDisplayName = displayName;
        this.myListenerClass = listenerClass;
        this.myBroadcastDirection = broadcastDirection;
    }

    @NotNull
    @NonNls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @NotNull
    public Class<L> getListenerClass() {
        return this.myListenerClass;
    }

    public String toString() {
        return this.myDisplayName;
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass) {
        return new Topic<L>(displayName, listenerClass);
    }

    @NotNull
    public static <L> Topic<L> create(@NonNls @NotNull String displayName, @NotNull Class<L> listenerClass, BroadcastDirection direction) {
        return new Topic<L>(displayName, listenerClass, direction);
    }

    @NotNull
    public BroadcastDirection getBroadcastDirection() {
        return this.myBroadcastDirection;
    }

    public static enum BroadcastDirection {
        TO_CHILDREN,
        NONE,
        TO_PARENT;

    }
}

