/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.messages.impl.MessageBusImpl");
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ContainerUtil.compareLexicographically(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue = MessageBusImpl.createThreadLocalQueue();
    private List<Integer> myOrder;
    private final ConcurrentMap<Topic, Object> myPublishers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscribers = ContainerUtil.newConcurrentMap();
    private final ConcurrentMap<Topic, List<MessageBusConnectionImpl>> mySubscriberCache = ContainerUtil.newConcurrentMap();
    private final List<MessageBusImpl> myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Object NA = new Object();
    private MessageBusImpl myParentBus;
    private final String myOwner;
    private boolean myDisposed;
    private final Disposable myConnectionDisposable;

    public MessageBusImpl(@NotNull Object owner, @NotNull MessageBus parentBus) {
        this(owner);
        this.myParentBus = (MessageBusImpl)parentBus;
        this.myParentBus.onChildBusCreated(this);
        LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
        LOG.assertTrue(this.myOrder != null);
    }

    private MessageBusImpl(Object owner) {
        this.myOwner = owner + " of " + owner.getClass();
        this.myConnectionDisposable = Disposer.newDisposable(this.myOwner);
        this.myOrder = new ArrayList<Integer>();
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    @NotNull
    private RootBus getRootBus() {
        return this.myParentBus != null ? this.myParentBus.getRootBus() : this.asRoot();
    }

    private MessageBusImpl rootBus() {
        return this.getRootBus();
    }

    private RootBus asRoot() {
        if (this instanceof RootBus) {
            return (RootBus)this;
        }
        throw new AssertionError((Object)("Accessing disposed message bus " + this));
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.myDisposed ? "; disposed" : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusCreated(MessageBusImpl childBus) {
        LOG.assertTrue(childBus.myParentBus == this);
        List<MessageBusImpl> list = this.myChildBuses;
        synchronized (list) {
            int lastChildIndex;
            MessageBusImpl lastChild = this.myChildBuses.isEmpty() ? null : this.myChildBuses.get(this.myChildBuses.size() - 1);
            this.myChildBuses.add(childBus);
            int n = lastChildIndex = lastChild == null ? 0 : lastChild.myOrder.get(lastChild.myOrder.size() - 1);
            if (lastChildIndex == Integer.MAX_VALUE) {
                LOG.error("Too many child buses");
            }
            ArrayList<Integer> childOrder = new ArrayList<Integer>(this.myOrder.size() + 1);
            childOrder.addAll(this.myOrder);
            childOrder.add(lastChildIndex + 1);
            childBus.myOrder = childOrder;
        }
        this.rootBus().clearSubscriberCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChildBusDisposed(MessageBusImpl childBus) {
        boolean removed;
        List<MessageBusImpl> list = this.myChildBuses;
        synchronized (list) {
            removed = this.myChildBuses.remove(childBus);
        }
        Map map = (Map)this.getRootBus().myWaitingBuses.get();
        if (map != null) {
            map.remove(childBus);
        }
        this.rootBus().clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnection connect() {
        return this.connect(this.myConnectionDisposable);
    }

    @Override
    @NotNull
    public MessageBusConnection connect(@NotNull Disposable parentDisposable) {
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        return connection;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(final @NotNull Topic<L> topic) {
        this.checkNotDisposed();
        Object publisher = this.myPublishers.get(topic);
        if (publisher == null) {
            Class<L> listenerClass = topic.getListenerClass();
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                        return EventDispatcher.handleObjectMethod(proxy, args, method.getName());
                    }
                    MessageBusImpl.this.sendMessage(new Message(topic, method, args));
                    return NA;
                }
            };
            publisher = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
            publisher = ConcurrencyUtil.cacheOrGet(this.myPublishers, topic, publisher);
        }
        return (L)publisher;
    }

    @Override
    public void dispose() {
        this.checkNotDisposed();
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        Disposer.dispose(this.myConnectionDisposable);
        Queue<DeliveryJob> jobs = this.myMessageQueue.get();
        if (!jobs.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
            this.myParentBus = null;
        } else {
            this.asRoot().myWaitingBuses.remove();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (!this.isDispatchingAnything()) {
            return false;
        }
        for (MessageBusConnectionImpl connection : this.getTopicSubscribers(topic)) {
            if (!connection.containsMessage(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isDispatchingAnything() {
        SortedMap waitingBuses = (SortedMap)this.getRootBus().myWaitingBuses.get();
        return waitingBuses != null && !waitingBuses.isEmpty();
    }

    private void checkNotDisposed() {
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
    }

    private void calcSubscribers(Topic topic, List<MessageBusConnectionImpl> result) {
        Topic.BroadcastDirection direction;
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers != null) {
            result.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                childBus.calcSubscribers(topic, result);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result);
        }
    }

    private void postMessage(Message message) {
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message.getTopic());
        if (!topicSubscribers.isEmpty()) {
            for (MessageBusConnectionImpl subscriber : topicSubscribers) {
                subscriber.getBus().myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
                subscriber.getBus().notifyPendingJobChange(1);
                subscriber.scheduleMessageDelivery(message);
            }
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(Topic topic) {
        SmartList<MessageBusConnectionImpl> topicSubscribers = (SmartList<MessageBusConnectionImpl>)this.mySubscriberCache.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = new SmartList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers);
            this.mySubscriberCache.put(topic, topicSubscribers);
        }
        return topicSubscribers;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.getRootBus().myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map == null) {
            map = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map);
        }
        if ((newCount = (count = (countObject = (Integer)map.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map.put(this, newCount);
        } else if (newCount == 0) {
            map.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(Message message) {
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        if (this.myParentBus != null) {
            LOG.assertTrue(this.myParentBus.myChildBuses.contains(this));
            this.myParentBus.pumpMessages();
        } else {
            Map map = (Map)this.asRoot().myWaitingBuses.get();
            if (map != null && !map.isEmpty()) {
                SmartList<MessageBusImpl> liveBuses = null;
                for (MessageBusImpl bus : map.keySet()) {
                    if (!MessageBusImpl.ensureAlive(map, bus)) continue;
                    if (liveBuses == null) {
                        liveBuses = new SmartList<MessageBusImpl>();
                    }
                    liveBuses.add(bus);
                }
                if (liveBuses != null) {
                    MessageBusImpl.pumpWaitingBuses(liveBuses);
                }
            }
        }
    }

    private static void pumpWaitingBuses(List<? extends MessageBusImpl> buses) {
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.myDisposed) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(List<Throwable> exceptions, List<? extends Throwable> busExceptions) {
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new SmartList<Throwable>();
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(List<Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(Map<MessageBusImpl, Integer> map, MessageBusImpl bus) {
        if (bus.myDisposed) {
            map.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    private List<Throwable> doPumpMessages() {
        DeliveryJob job;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        SmartList<Throwable> exceptions = null;
        while ((job = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job.connection.deliverMessage(job.message);
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        return exceptions == null ? Collections.emptyList() : exceptions;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.rootBus().clearSubscriberCache();
    }

    private void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(MessageBusConnectionImpl connection) {
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.myDisposed) {
            return;
        }
        this.rootBus().clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job = (DeliveryJob)i.next();
            if (job.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job = this.myMessageQueue.get().poll();
        if (job == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job.connection.deliverMessage(job.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        return ThreadLocal.withInitial(ConcurrentLinkedQueue::new);
    }

    public static class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses = new ThreadLocal();

        public RootBus(@NotNull Object owner) {
            super(owner);
        }
    }

    private static class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(MessageBusConnectionImpl connection, Message message) {
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }
    }
}

