/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ref;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.Queue;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class DebugReflectionUtil {
    private static final Map<Class, Field[]> allFields = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Class>(){

        public int computeHashCode(Class aClass) {
            return aClass.getName().hashCode();
        }

        public boolean equals(Class o1, Class o2) {
            return o1 == o2;
        }
    });
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method Unsafe_shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Unsafe.class, "shouldBeInitialized", Class.class);
    private static final Key<Boolean> REPORTED_LEAKED = Key.create("REPORTED_LEAKED");

    @NotNull
    public static Field[] getAllFields(@NotNull Class aClass) {
        Field[] cached = allFields.get(aClass);
        if (cached == null) {
            try {
                Field[] declaredFields = aClass.getDeclaredFields();
                ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type)) continue;
                    fields.add(declaredField);
                }
                Class superclass = aClass.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields.contains(sup)) continue;
                        fields.add(sup);
                    }
                }
                cached = fields.isEmpty() ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[0]);
            }
            catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                    cached = EMPTY_FIELD_ARRAY;
                }
                throw e;
            }
            allFields.put(aClass, cached);
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type) {
        return type.isPrimitive() || type == String.class || type == Class.class || type.isArray() && DebugReflectionUtil.isTrivial(type.getComponentType());
    }

    public static boolean isInitialized(@NotNull Class root) {
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke((Object)AtomicFieldUpdater.getUnsafe(), root) == false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static boolean walkObjects(int maxDepth, @NotNull Map<Object, String> startRoots, @NotNull Class<?> lookFor, @NotNull Condition<Object> shouldExamineValue, @NotNull PairProcessor<Object, ? super BackLink> leakProcessor) {
        TIntHashSet visited = new TIntHashSet(100);
        Queue<2> toVisit = new Queue<2>(100);
        for (Map.Entry<Object, String> entry : startRoots.entrySet()) {
            Object startRoot = entry.getKey();
            final String description = entry.getValue();
            toVisit.addLast(new BackLink(startRoot, null, null){

                @Override
                @NotNull
                String print() {
                    return super.print() + " (from " + description + ")";
                }
            });
        }
        while (!toVisit.isEmpty()) {
            BackLink backLink = (BackLink)toVisit.pullFirst();
            if (backLink.depth > maxDepth) continue;
            Object value = backLink.value;
            if (lookFor.isAssignableFrom(value.getClass()) && DebugReflectionUtil.markLeaked(value) && !leakProcessor.process(value, backLink)) {
                return false;
            }
            if (!visited.add(System.identityHashCode(value))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value, shouldExamineValue, backLink);
        }
        return true;
    }

    private static void queueStronglyReferencedValues(@NotNull Queue<? super BackLink> queue, @NotNull Object root, @NotNull Condition<Object> shouldExamineValue, @NotNull BackLink backLink) {
        Class<?> rootClass = root.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root instanceof Reference && ("referent".equals(fieldName) || "discovered".equals(fieldName))) continue;
            try {
                value = field.get(root);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root) {
                    DebugReflectionUtil.queue(object, null, backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root instanceof Class && DebugReflectionUtil.isInitialized((Class)root)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value = field.get(null);
                    DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(Object value, Field field, @NotNull BackLink backLink, @NotNull Queue<? super BackLink> queue, @NotNull Condition<Object> shouldExamineValue) {
        if (value == null || DebugReflectionUtil.isTrivial(value.getClass())) {
            return;
        }
        if (shouldExamineValue.value(value)) {
            BackLink newBackLink = new BackLink(value, field, backLink);
            queue.addLast(newBackLink);
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    public static class BackLink {
        @NotNull
        private final Object value;
        private final Field field;
        private final BackLink backLink;
        private final int depth;

        BackLink(@NotNull Object value, @Nullable Field field, @Nullable BackLink backLink) {
            this.value = value;
            this.field = field;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            String result = "";
            BackLink backLink = this;
            while (backLink != null) {
                String s = backLink.print();
                result = result + s;
                backLink = backLink.backLink;
            }
            return result;
        }

        @NotNull
        String print() {
            String valueStr;
            Object value = this.value;
            try {
                valueStr = value instanceof FList ? "FList (size=" + ((FList)value).size() + ")" : (value instanceof Collection ? "Collection (size=" + ((Collection)value).size() + ")" : String.valueOf(value));
                valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
            }
            catch (Throwable e) {
                valueStr = "(" + e.getMessage() + " while computing .toString())";
            }
            Field field = this.field;
            String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
            return "via '" + fieldName + "'; Value: '" + valueStr + "' of " + value.getClass() + "\n";
        }
    }
}

