/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.CommonBundle;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SyncDateFormat;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class DateFormatUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.util.text.DateFormatUtil");
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final long DAY_FACTOR = 86400000L;
    private static final SyncDateFormat DATE_FORMAT;
    private static final SyncDateFormat TIME_FORMAT;
    private static final SyncDateFormat TIME_WITH_SECONDS_FORMAT;
    private static final SyncDateFormat DATE_TIME_FORMAT;
    private static final SyncDateFormat ABOUT_DATE_FORMAT;
    private static final SyncDateFormat ISO8601_FORMAT;
    private static final long[] DENOMINATORS;
    private static final Period[] PERIODS;

    private DateFormatUtil() {
    }

    public static long getDifferenceInDays(@NotNull Date startDate, @NotNull Date endDate) {
        return (endDate.getTime() - startDate.getTime() + 86400000L - 1000L) / 86400000L;
    }

    @NotNull
    public static SyncDateFormat getDateFormat() {
        return DATE_FORMAT;
    }

    @NotNull
    public static SyncDateFormat getTimeFormat() {
        return TIME_FORMAT;
    }

    @NotNull
    public static SyncDateFormat getTimeWithSecondsFormat() {
        return TIME_WITH_SECONDS_FORMAT;
    }

    @NotNull
    public static SyncDateFormat getDateTimeFormat() {
        return DATE_TIME_FORMAT;
    }

    @NotNull
    public static SyncDateFormat getIso8601Format() {
        return ISO8601_FORMAT;
    }

    @NotNull
    public static String formatTime(@NotNull Date time) {
        return DateFormatUtil.formatTime(time.getTime());
    }

    @NotNull
    public static String formatTime(long time) {
        return DateFormatUtil.getTimeFormat().format(time);
    }

    @NotNull
    public static String formatTimeWithSeconds(@NotNull Date time) {
        return DateFormatUtil.formatTimeWithSeconds(time.getTime());
    }

    @NotNull
    public static String formatTimeWithSeconds(long time) {
        return DateFormatUtil.getTimeWithSecondsFormat().format(time);
    }

    @NotNull
    public static String formatDate(@NotNull Date time) {
        return DateFormatUtil.formatDate(time.getTime());
    }

    @NotNull
    public static String formatDate(long time) {
        return DateFormatUtil.getDateFormat().format(time);
    }

    @NotNull
    public static String formatPrettyDate(@NotNull Date date) {
        return DateFormatUtil.formatPrettyDate(date.getTime());
    }

    @NotNull
    public static String formatPrettyDate(long time) {
        return DateFormatUtil.doFormatPretty(time, false);
    }

    @NotNull
    public static String formatDateTime(Date date) {
        return DateFormatUtil.formatDateTime(date.getTime());
    }

    @NotNull
    public static String formatDateTime(long time) {
        return DateFormatUtil.getDateTimeFormat().format(time);
    }

    @NotNull
    public static String formatPrettyDateTime(@NotNull Date date) {
        return DateFormatUtil.formatPrettyDateTime(date.getTime());
    }

    @NotNull
    public static String formatPrettyDateTime(long time) {
        return DateFormatUtil.doFormatPretty(time, true);
    }

    @NotNull
    private static String doFormatPretty(long time, boolean formatTime) {
        boolean isYesterday;
        boolean isToday;
        long delta;
        long currentTime = Clock.getTime();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(currentTime);
        int currentYear = c.get(1);
        int currentDayOfYear = c.get(6);
        c.setTimeInMillis(time);
        int year = c.get(1);
        int dayOfYear = c.get(6);
        if (LOG.isTraceEnabled()) {
            LOG.trace("now=" + currentTime + " t=" + time + " z=" + c.getTimeZone());
        }
        if (formatTime && (delta = currentTime - time) >= 0L && delta <= 3660000L) {
            return CommonBundle.message("date.format.minutes.ago", (int)Math.rint((double)delta / 60000.0));
        }
        boolean bl = isToday = currentYear == year && currentDayOfYear == dayOfYear;
        if (isToday) {
            String result = CommonBundle.message("date.format.today", new Object[0]);
            return formatTime ? result + " " + TIME_FORMAT.format(time) : result;
        }
        boolean isYesterdayOnPreviousYear = currentYear == year + 1 && currentDayOfYear == 1 && dayOfYear == c.getActualMaximum(6);
        boolean bl2 = isYesterday = isYesterdayOnPreviousYear || currentYear == year && currentDayOfYear == dayOfYear + 1;
        if (isYesterday) {
            String result = CommonBundle.message("date.format.yesterday", new Object[0]);
            return formatTime ? result + " " + TIME_FORMAT.format(time) : result;
        }
        return formatTime ? DATE_TIME_FORMAT.format(time) : DATE_FORMAT.format(time);
    }

    @NotNull
    public static String formatDuration(long delta) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            int n = (int)(delta / denominator);
            if (n == 0) continue;
            buf.append(DateFormatUtil.composeDurationMessage(PERIODS[i], n));
            buf.append(' ');
            delta %= denominator;
        }
        if (buf.length() == 0) {
            return CommonBundle.message("date.format.less.than.a.minute", new Object[0]);
        }
        return buf.toString().trim();
    }

    private static String composeDurationMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.n.years", n);
    }

    @NotNull
    public static String formatFrequency(long time) {
        return CommonBundle.message("date.frequency", DateFormatUtil.formatBetweenDates(time, 0L));
    }

    @NotNull
    public static String formatBetweenDates(long d1, long d2) {
        int i;
        long delta = Math.abs(d1 - d2);
        if (delta == 0L) {
            return CommonBundle.message("date.format.right.now", new Object[0]);
        }
        int n = -1;
        for (i = 0; i < DENOMINATORS.length; ++i) {
            long denominator = DENOMINATORS[i];
            if (delta < denominator) continue;
            n = (int)(delta / denominator);
            break;
        }
        if (d2 > d1) {
            if (n <= 0) {
                return CommonBundle.message("date.format.a.few.moments.ago", new Object[0]);
            }
            return DateFormatUtil.someTimeAgoMessage(PERIODS[i], n);
        }
        if (d2 < d1) {
            if (n <= 0) {
                return CommonBundle.message("date.format.in.a.few.moments", new Object[0]);
            }
            return DateFormatUtil.composeInSomeTimeMessage(PERIODS[i], n);
        }
        return "";
    }

    @NotNull
    public static String formatAboutDialogDate(@NotNull Date date) {
        return DateFormatUtil.formatAboutDialogDate(date.getTime());
    }

    @NotNull
    public static String formatAboutDialogDate(long time) {
        return ABOUT_DATE_FORMAT.format(time);
    }

    private static String someTimeAgoMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.n.days.ago", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.n.minutes.ago", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.n.hours.ago", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.n.months.ago", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.n.weeks.ago", n);
            }
        }
        return CommonBundle.message("date.format.n.years.ago", n);
    }

    private static String composeInSomeTimeMessage(Period period, int n) {
        switch (period) {
            case DAY: {
                return CommonBundle.message("date.format.in.n.days", n);
            }
            case MINUTE: {
                return CommonBundle.message("date.format.in.n.minutes", n);
            }
            case HOUR: {
                return CommonBundle.message("date.format.in.n.hours", n);
            }
            case MONTH: {
                return CommonBundle.message("date.format.in.n.months", n);
            }
            case WEEK: {
                return CommonBundle.message("date.format.in.n.weeks", n);
            }
        }
        return CommonBundle.message("date.format.in.n.years", n);
    }

    private static SyncDateFormat[] getDateTimeFormats() {
        DateFormat[] formats = null;
        try {
            if (SystemInfo.isMac && JnaLoader.isLoaded()) {
                formats = DateFormatUtil.getMacFormats();
            } else if (SystemInfo.isUnix) {
                formats = DateFormatUtil.getUnixFormats();
            } else if (SystemInfo.isWin7OrNewer && JnaLoader.isLoaded()) {
                formats = DateFormatUtil.getWindowsFormats();
            }
        }
        catch (Throwable t) {
            LOG.error(t);
        }
        if (formats == null) {
            formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getDateTimeInstance(3, 3)};
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("formats (OS=" + SystemInfo.OS_NAME + " JNA=" + JnaLoader.isLoaded() + ")");
            for (DateFormat format : formats) {
                LOG.trace("'" + (format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : format.toString()) + "'");
            }
        }
        SyncDateFormat[] synced = new SyncDateFormat[4];
        for (int i = 0; i < formats.length; ++i) {
            synced[i] = new SyncDateFormat(formats[i]);
        }
        return synced;
    }

    private static DateFormat[] getMacFormats() {
        CF cf = (CF)Native.loadLibrary((String)"CoreFoundation", CF.class);
        return new DateFormat[]{DateFormatUtil.getMacFormat(cf, 1L, 0L), DateFormatUtil.getMacFormat(cf, 0L, 1L), DateFormatUtil.getMacFormat(cf, 0L, 2L), DateFormatUtil.getMacFormat(cf, 1L, 1L)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getMacFormat(CF cf, long dateStyle, long timeStyle) {
        Pointer formatter = cf.CFDateFormatterCreate(null, null, dateStyle, timeStyle);
        if (formatter == null) {
            throw new IllegalStateException("CFDateFormatterCreate: null");
        }
        try {
            Pointer format = cf.CFDateFormatterGetFormat(formatter);
            int length = (int)cf.CFStringGetLength(format);
            char[] buffer = new char[length];
            cf.CFStringGetCharacters(format, new CF.CFRange(0L, length), buffer);
            DateFormat dateFormat = DateFormatUtil.formatFromString(new String(buffer));
            return dateFormat;
        }
        finally {
            cf.CFRelease(formatter);
        }
    }

    private static DateFormat[] getUnixFormats() {
        String localeStr = System.getenv("LC_TIME");
        if (LOG.isTraceEnabled()) {
            LOG.trace("LC_TIME=" + localeStr);
        }
        if (localeStr == null) {
            return null;
        }
        int p = (localeStr = localeStr.trim()).indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        Locale locale = (p = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
        return new DateFormat[]{DateFormat.getDateInstance(3, locale), DateFormat.getTimeInstance(3, locale), DateFormat.getTimeInstance(2, locale), DateFormat.getDateTimeInstance(3, 3, locale)};
    }

    private static DateFormat[] getWindowsFormats() {
        int bufferSize;
        char[] buffer;
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class);
        int rv = kernel32.GetLocaleInfoEx(null, 31, buffer = new char[bufferSize = 128], bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortDate = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 121, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 4099, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumTime = DateFormatUtil.fixWindowsFormat(new String(buffer, 0, rv - 1));
        return new DateFormat[]{DateFormatUtil.formatFromString(shortDate), DateFormatUtil.formatFromString(shortTime), DateFormatUtil.formatFromString(mediumTime), DateFormatUtil.formatFromString(shortDate + " " + shortTime)};
    }

    private static String fixWindowsFormat(String format) {
        format = format.replaceAll("g+", "G");
        format = StringUtil.replace(format, "tt", "a");
        return format;
    }

    private static DateFormat formatFromString(String format) {
        try {
            return new SimpleDateFormat(format.trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized format string '" + format + "'");
        }
    }

    static {
        SyncDateFormat[] formats = DateFormatUtil.getDateTimeFormats();
        DATE_FORMAT = formats[0];
        TIME_FORMAT = formats[1];
        TIME_WITH_SECONDS_FORMAT = formats[2];
        DATE_TIME_FORMAT = formats[3];
        ABOUT_DATE_FORMAT = new SyncDateFormat(DateFormat.getDateInstance(1, Locale.US));
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601_FORMAT = new SyncDateFormat(iso8601);
        DENOMINATORS = new long[]{31536000000L, 2592000000L, 604800000L, 86400000L, 3600000L, 60000L};
        PERIODS = new Period[]{Period.YEAR, Period.MONTH, Period.WEEK, Period.DAY, Period.HOUR, Period.MINUTE};
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, char[] var3, int var4);

        public int GetLastError();
    }

    private static interface CF
    extends Library {
        public static final long kCFDateFormatterNoStyle = 0L;
        public static final long kCFDateFormatterShortStyle = 1L;
        public static final long kCFDateFormatterMediumStyle = 2L;

        public Pointer CFDateFormatterCreate(Pointer var1, Pointer var2, long var3, long var5);

        public Pointer CFDateFormatterGetFormat(Pointer var1);

        public long CFStringGetLength(Pointer var1);

        public void CFStringGetCharacters(Pointer var1, CFRange var2, char[] var3);

        public void CFRelease(Pointer var1);

        public static class CFRange
        extends Structure
        implements Structure.ByValue {
            public long location;
            public long length;

            protected List<String> getFieldOrder() {
                return Arrays.asList("location", "length");
            }

            public CFRange(long location, long length) {
                this.location = location;
                this.length = length;
            }
        }
    }

    private static enum Period {
        YEAR,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE;

    }
}

