/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

final class ImmutableText
extends ImmutableCharSequence
implements CharArrayExternalizable,
CharSequenceWithStringHash {
    private static final int BLOCK_SIZE = 64;
    private static final int BLOCK_MASK = -64;
    private final Node myNode;
    private static final LeafNode EMPTY_NODE = new Leaf8BitNode(ArrayUtil.EMPTY_BYTE_ARRAY);
    private static final ImmutableText EMPTY = new ImmutableText(EMPTY_NODE);
    private transient int hash;
    private InnerLeaf myLastLeaf;

    private ImmutableText(Node node) {
        this.myNode = node;
    }

    static ImmutableText valueOf(@NotNull Object obj) {
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        return new ImmutableText(ImmutableText.createLeafNode(str));
    }

    private static LeafNode createLeafNode(@NotNull CharSequence str) {
        byte[] bytes = ByteArrayCharSequence.toBytesIfPossible(str);
        if (bytes != null) {
            return new Leaf8BitNode(bytes);
        }
        char[] chars = new char[str.length()];
        CharArrayUtil.getChars(str, chars, 0, 0, str.length());
        return new WideLeafNode(chars);
    }

    private ImmutableText ensureChunked() {
        if (this.length() > 64 && this.myNode instanceof LeafNode) {
            return new ImmutableText(ImmutableText.nodeOf((LeafNode)this.myNode, 0, this.length()));
        }
        return this;
    }

    private static Node nodeOf(@NotNull LeafNode node, int offset, int length) {
        if (length <= 64) {
            return node.subNode(offset, offset + length);
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new CompositeNode(ImmutableText.nodeOf(node, offset, half), ImmutableText.nodeOf(node, offset + half, length - half));
    }

    @Override
    public int length() {
        return this.myNode.length();
    }

    private ImmutableText concat(ImmutableText that) {
        return that.length() == 0 ? this : (this.length() == 0 ? that : new ImmutableText(ImmutableText.concatNodes(this.ensureChunked().myNode, that.ensureChunked().myNode)));
    }

    @Override
    public ImmutableText concat(@NotNull CharSequence sequence) {
        return this.concat(ImmutableText.valueOf(sequence));
    }

    private ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    @Override
    public ImmutableText insert(int index, @NotNull CharSequence seq) {
        if (seq.length() == 0) {
            return this;
        }
        return this.subtext(0, index).concat(ImmutableText.valueOf(seq)).concat(this.subtext(index));
    }

    @Override
    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.ensureChunked().subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        return CharArrayUtil.regionMatches(this, 0, (ImmutableText)obj);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public char charAt(int index) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index < leaf.offset || index >= leaf.end) {
            this.myLastLeaf = leaf = this.findLeaf(index);
        }
        return leaf.leafNode.charAt(index - leaf.offset);
    }

    private InnerLeaf findLeaf(int index) {
        Node node = this.myNode;
        if (index < 0 || index >= node.length()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        int offset = 0;
        while (true) {
            if (index >= node.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (node instanceof LeafNode) {
                return new InnerLeaf((LeafNode)node, offset);
            }
            CompositeNode composite = (CompositeNode)node;
            if (index < composite.head.length()) {
                node = composite.head;
                continue;
            }
            offset += composite.head.length();
            index -= composite.head.length();
            node = composite.tail;
        }
    }

    @Override
    public ImmutableText subtext(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (start == end) {
            return EMPTY;
        }
        return new ImmutableText(this.myNode.subNode(start, end));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        this.myNode.getChars(start, end, dest, destPos);
    }

    @Override
    @NotNull
    public String toString() {
        return this.myNode.toString();
    }

    @NotNull
    private static Node concatNodes(@NotNull Node node1, @NotNull Node node2) {
        int length = node1.length() + node2.length();
        if (length <= 64) {
            return ImmutableText.createLeafNode(new MergingCharSequence(node1, node2));
        }
        Node head = node1;
        Node tail = node2;
        if (head.length() << 1 < tail.length() && tail instanceof CompositeNode) {
            if (((CompositeNode)tail).head.length() > ((CompositeNode)tail).tail.length()) {
                tail = ((CompositeNode)tail).rightRotation();
            }
            head = ImmutableText.concatNodes(head, ((CompositeNode)tail).head);
            tail = ((CompositeNode)tail).tail;
        } else if (tail.length() << 1 < head.length() && head instanceof CompositeNode) {
            if (((CompositeNode)head).tail.length() > ((CompositeNode)head).head.length()) {
                head = ((CompositeNode)head).leftRotation();
            }
            tail = ImmutableText.concatNodes(((CompositeNode)head).tail, tail);
            head = ((CompositeNode)head).head;
        }
        return new CompositeNode(head, tail);
    }

    private static class CompositeNode
    extends Node {
        final int count;
        final Node head;
        final Node tail;

        CompositeNode(Node head, Node tail) {
            this.count = head.length() + tail.length();
            this.head = head;
            this.tail = tail;
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public char charAt(int index) {
            int headLength = this.head.length();
            return index < headLength ? this.head.charAt(index) : this.tail.charAt(index - headLength);
        }

        Node rightRotation() {
            Node P3 = this.head;
            if (!(P3 instanceof CompositeNode)) {
                return this;
            }
            Node A = ((CompositeNode)P3).head;
            Node B = ((CompositeNode)P3).tail;
            Node C = this.tail;
            return new CompositeNode(A, new CompositeNode(B, C));
        }

        Node leftRotation() {
            Node Q = this.tail;
            if (!(Q instanceof CompositeNode)) {
                return this;
            }
            Node B = ((CompositeNode)Q).head;
            Node C = ((CompositeNode)Q).tail;
            Node A = this.head;
            return new CompositeNode(new CompositeNode(A, B), C);
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            int cesure = this.head.length();
            if (end <= cesure) {
                this.head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this.tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this.head.getChars(start, cesure, dest, destPos);
                this.tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        Node subNode(int start, int end) {
            int cesure = this.head.length();
            if (end <= cesure) {
                return this.head.subNode(start, end);
            }
            if (start >= cesure) {
                return this.tail.subNode(start - cesure, end - cesure);
            }
            if (start == 0 && end == this.count) {
                return this;
            }
            return ImmutableText.concatNodes(this.head.subNode(start, cesure), this.tail.subNode(0, end - cesure));
        }
    }

    private static class Leaf8BitNode
    extends LeafNode {
        private final byte[] data;

        Leaf8BitNode(@NotNull byte[] data) {
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = start; i < end; ++i) {
                dest[destPos++] = Leaf8BitNode.byteToChar(this.data[i]);
            }
        }

        @Override
        LeafNode subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            int length = end - start;
            byte[] chars = new byte[length];
            System.arraycopy(this.data, start, chars, 0, length);
            return new Leaf8BitNode(chars);
        }

        @Override
        public char charAt(int index) {
            return Leaf8BitNode.byteToChar(this.data[index]);
        }

        private static char byteToChar(byte b) {
            return (char)(b & 0xFF);
        }
    }

    private static class WideLeafNode
    extends LeafNode {
        private final char[] data;

        WideLeafNode(@NotNull char[] data) {
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this.data, start, dest, destPos, end - start);
        }

        @Override
        Node subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            return ImmutableText.createLeafNode(new CharArrayCharSequence(this.data, start, end));
        }

        @Override
        @NotNull
        public String toString() {
            return StringFactory.createShared(this.data);
        }

        @Override
        public char charAt(int index) {
            return this.data[index];
        }
    }

    private static abstract class LeafNode
    extends Node {
        private LeafNode() {
        }
    }

    private static abstract class Node
    implements CharSequence {
        private Node() {
        }

        abstract void getChars(int var1, int var2, @NotNull char[] var3, int var4);

        abstract Node subNode(int var1, int var2);

        @Override
        @NotNull
        public String toString() {
            int len = this.length();
            char[] data = new char[len];
            this.getChars(0, len, data, 0);
            return StringFactory.createShared(data);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.subNode(start, end);
        }
    }

    private static class InnerLeaf {
        final LeafNode leafNode;
        final int offset;
        final int end;

        private InnerLeaf(@NotNull LeafNode leafNode, int offset) {
            this.leafNode = leafNode;
            this.offset = offset;
            this.end = offset + leafNode.length();
        }
    }
}

