/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.SystemInfo;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;

public class StringFactory {
    private static final Constructor<String> ourConstructor;

    @NotNull
    public static String createShared(@NotNull char[] chars) {
        if (ourConstructor != null) {
            try {
                return ourConstructor.newInstance(chars, Boolean.TRUE);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new String(chars);
    }

    static {
        Constructor constructor = null;
        if (!SystemInfo.IS_AT_LEAST_JAVA9) {
            try {
                constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                constructor.setAccessible(true);
            }
            catch (Throwable ignored) {
                constructor = null;
            }
        }
        ourConstructor = constructor;
    }
}

