/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextRangeUtil {
    public static final Comparator<TextRange> RANGE_COMPARATOR = (range1, range2) -> {
        int startOffsetDiff = range1.getStartOffset() - range2.getStartOffset();
        return startOffsetDiff != 0 ? startOffsetDiff : range1.getEndOffset() - range2.getEndOffset();
    };

    private TextRangeUtil() {
    }

    public static Iterable<TextRange> excludeRanges(@NotNull TextRange original, @NotNull List<? extends TextRange> excludedRanges) {
        if (!excludedRanges.isEmpty()) {
            if (excludedRanges.size() > 1) {
                excludedRanges.sort(RANGE_COMPARATOR);
            }
            int enabledRangeStart = original.getStartOffset();
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            for (TextRange textRange : excludedRanges) {
                if (textRange.getEndOffset() < enabledRangeStart) continue;
                int excludedRangeStart = textRange.getStartOffset();
                if (excludedRangeStart > original.getEndOffset()) break;
                if (excludedRangeStart > enabledRangeStart) {
                    enabledRanges.add(new TextRange(enabledRangeStart, excludedRangeStart));
                }
                enabledRangeStart = textRange.getEndOffset();
            }
            if (enabledRangeStart < original.getEndOffset()) {
                enabledRanges.add(new TextRange(enabledRangeStart, original.getEndOffset()));
            }
            return enabledRanges;
        }
        return Collections.singletonList(original);
    }

    @NotNull
    public static TextRange getEnclosingTextRange(@NotNull List<? extends TextRange> textRanges) {
        if (textRanges.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        int lowerBound = textRanges.get(0).getStartOffset();
        int upperBound = textRanges.get(0).getEndOffset();
        for (int i = 1; i < textRanges.size(); ++i) {
            TextRange textRange = textRanges.get(i);
            lowerBound = Math.min(lowerBound, textRange.getStartOffset());
            upperBound = Math.max(upperBound, textRange.getEndOffset());
        }
        return new TextRange(lowerBound, upperBound);
    }

    public static int getDistance(@NotNull Segment r2, @NotNull Segment r1) {
        int s1 = r1.getStartOffset();
        int e1 = r1.getEndOffset();
        int s2 = r2.getStartOffset();
        int e2 = r2.getEndOffset();
        return Math.max(s1, s2) <= Math.min(e1, e2) ? 0 : Math.min(Math.abs(s1 - e2), Math.abs(s2 - e1));
    }
}

