/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames = new THashSet();

    public <T> UniqueNameGenerator(@NotNull Collection<T> elements, @Nullable Function<T, String> namer) {
        for (T t : elements) {
            this.addExistingName(namer != null ? StringUtil.notNullize(namer.fun(t)) : t.toString());
        }
    }

    public UniqueNameGenerator() {
    }

    @Override
    public final boolean value(String candidate) {
        return this.isUnique(candidate);
    }

    public final boolean isUnique(@NotNull String candidate) {
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(String name, String prefix, String suffix) {
        return this.value(prefix + name + suffix);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", existingNames);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, Collection<String> existingNames) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, (? super String s) -> !existingNames.contains(s));
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Condition<? super String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, "", "", validator);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, Condition<? super String> validator) {
        return UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, "", "", validator);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber, Condition<? super String> validator) {
        String defaultFullName = (prefix + defaultName + suffix).trim();
        if (validator.value(defaultFullName)) {
            return defaultFullName;
        }
        int i = 2;
        String fullName;
        while (!validator.value(fullName = (prefix + defaultName + beforeNumber + i + afterNumber + suffix).trim())) {
            ++i;
        }
        return fullName;
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        return this.generateUniqueName(defaultName, prefix, suffix, "", "");
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result);
        return result;
    }

    public void addExistingName(@NotNull String result) {
        this.myExistingNames.add(result);
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

