/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EdtInvocationManager {
    @NotNull
    private static EdtInvocationManager ourInstance = new SwingEdtInvocationManager();

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        return ourInstance;
    }

    public static void setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        ourInstance = edtInvocationManager;
    }

    private static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        private SwingEdtInvocationManager() {
        }

        @Override
        public boolean isEventDispatchThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            SwingUtilities.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            SwingUtilities.invokeAndWait(task);
        }
    }
}

