/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyIcon
extends JBUI.CachingScalableJBIcon<EmptyIcon> {
    private static final Map<Pair<Integer, Boolean>, EmptyIcon> cache = new HashMap<Pair<Integer, Boolean>, EmptyIcon>();
    public static final Icon ICON_18 = JBUI.scale(EmptyIcon.create(18));
    public static final Icon ICON_16 = JBUI.scale(EmptyIcon.create(16));
    public static final Icon ICON_13 = JBUI.scale(EmptyIcon.create(13));
    public static final Icon ICON_8 = JBUI.scale(EmptyIcon.create(8));
    public static final Icon ICON_0 = JBUI.scale(EmptyIcon.create(0));
    protected final int width;
    protected final int height;
    private final boolean myUseCache;

    public static EmptyIcon create(int size) {
        return EmptyIcon.create(size, size);
    }

    public static EmptyIcon create(int width, int height) {
        return EmptyIcon.create(width, height, true);
    }

    public static EmptyIcon create(@NotNull Icon base) {
        return EmptyIcon.create(base.getIconWidth(), base.getIconHeight());
    }

    @Deprecated
    public EmptyIcon(int size) {
        this(size, size);
    }

    @Deprecated
    public EmptyIcon(int width, int height) {
        this(width, height, false);
    }

    private EmptyIcon(int width, int height, boolean useCache) {
        this.width = width;
        this.height = height;
        this.myUseCache = useCache;
    }

    protected EmptyIcon(EmptyIcon icon) {
        super(icon);
        this.width = icon.width;
        this.height = icon.height;
        this.myUseCache = icon.myUseCache;
    }

    @Override
    @NotNull
    public EmptyIcon copy() {
        return new EmptyIcon(this);
    }

    @Override
    @NotNull
    public EmptyIcon withIconPreScaled(boolean preScaled) {
        if (this.myUseCache && this.isIconPreScaled() != preScaled) {
            return EmptyIcon.create(this.width, this.height, preScaled);
        }
        return (EmptyIcon)super.withIconPreScaled(preScaled);
    }

    private static EmptyIcon create(int width, int height, boolean preScaled) {
        EmptyIcon icon;
        Pair<Integer, Boolean> key = EmptyIcon.key(width, height, preScaled);
        EmptyIcon emptyIcon = icon = key != null ? cache.get(key) : null;
        if (icon == null) {
            icon = new EmptyIcon(width, height, true);
            icon.setIconPreScaled(preScaled);
            if (key != null) {
                cache.put(key, icon);
            }
        }
        return icon;
    }

    @Nullable
    private static Pair<Integer, Boolean> key(int width, int height, boolean preScaled) {
        return width == height && width < 129 ? Pair.create(width, preScaled) : null;
    }

    @Override
    public int getIconWidth() {
        return (int)Math.ceil(this.scaleVal(this.width));
    }

    @Override
    public int getIconHeight() {
        return (int)Math.ceil(this.scaleVal(this.height));
    }

    @Override
    public void paintIcon(Component component, Graphics g, int i, int j) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmptyIcon)) {
            return false;
        }
        EmptyIcon icon = (EmptyIcon)o;
        if (this.scaleVal(this.height, JBUI.ScaleType.PIX_SCALE) != icon.scaleVal(icon.height, JBUI.ScaleType.PIX_SCALE)) {
            return false;
        }
        return this.scaleVal(this.width, JBUI.ScaleType.PIX_SCALE) == icon.scaleVal(icon.width, JBUI.ScaleType.PIX_SCALE);
    }

    public int hashCode() {
        double result = this.scaleVal(this.width, JBUI.ScaleType.PIX_SCALE);
        result = 31.0 * result + this.scaleVal(this.height, JBUI.ScaleType.PIX_SCALE);
        return (int)result;
    }

    public EmptyIconUIResource asUIResource() {
        return new EmptyIconUIResource(this);
    }

    static {
        JBUI.addPropertyChangeListener("JBUI.userScaleFactor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                cache.clear();
            }
        });
    }

    public static class EmptyIconUIResource
    extends EmptyIcon
    implements UIResource {
        protected EmptyIconUIResource(EmptyIcon icon) {
            super(icon);
        }

        @Override
        @NotNull
        public EmptyIconUIResource copy() {
            return new EmptyIconUIResource(this);
        }
    }
}

