/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ImageLoader;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtil {
    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image) {
        return ImageUtil.toBufferedImage(image, false);
    }

    @NotNull
    public static BufferedImage toBufferedImage(@NotNull Image image, boolean inUserSize) {
        JBHiDPIScaledImage jbImage;
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = (jbImage = (JBHiDPIScaledImage)image).getDelegate()) != null) {
            if (inUserSize) {
                double scale = jbImage.getScale();
                img = ImageUtil.scaleImage(img, 1.0 / scale);
            }
            image = img;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        final int width = image.getWidth(null);
        final int height = image.getHeight(null);
        if (width <= 0 || height <= 0) {
            return new BufferedImage(Math.max(width, 1), Math.max(height, 1), 2){

                @Override
                public int getWidth() {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight() {
                    return Math.max(height, 0);
                }

                @Override
                public int getWidth(ImageObserver observer) {
                    return Math.max(width, 0);
                }

                @Override
                public int getHeight(ImageObserver observer) {
                    return Math.max(height, 0);
                }
            };
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static double getImageScale(Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getScale();
        }
        return 1.0;
    }

    public static int getRealWidth(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getWidth(null);
    }

    public static int getRealHeight(@NotNull Image image) {
        Image img;
        if (image instanceof JBHiDPIScaledImage && (img = ((JBHiDPIScaledImage)image).getDelegate()) != null) {
            image = img;
        }
        return image.getHeight(null);
    }

    public static int getUserWidth(@NotNull Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserWidth(null);
        }
        return image.getWidth(null);
    }

    public static int getUserHeight(@NotNull Image image) {
        if (image instanceof JBHiDPIScaledImage) {
            return ((JBHiDPIScaledImage)image).getUserHeight(null);
        }
        return image.getHeight(null);
    }

    public static Image filter(Image image, ImageFilter filter) {
        if (image == null || filter == null) {
            return image;
        }
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image).getSource(), filter));
    }

    public static Image scaleImage(Image image, double scale) {
        return ImageLoader.scaleImage(image, scale);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Image ensureHiDPI(@Nullable Image image, @NotNull JBUI.ScaleContext ctx) {
        if (image == null) {
            return null;
        }
        if (UIUtil.isJreHiDPI(ctx)) {
            return RetinaImage.createFrom(image, ctx.getScale(JBUI.ScaleType.SYS_SCALE), null);
        }
        return image;
    }
}

