/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MyScaler;
import java.awt.Dimension;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class JBDimension
extends Dimension {
    Size2D size2D;
    private final MyScaler scaler = new MyScaler();

    public JBDimension(int width, int height) {
        this(width, height, false);
    }

    public JBDimension(int width, int height, boolean preScaled) {
        this((double)width, (double)height, preScaled);
    }

    private JBDimension(double width, double height, boolean preScaled) {
        this.size2D = new Size2D(preScaled ? width : this.scale(width), preScaled ? height : this.scale(height));
        this.set(this.size2D);
    }

    private double scale(double size) {
        return Math.max(-1.0f, JBUI.scale((float)size));
    }

    @NotNull
    public static JBDimension create(Dimension from, boolean preScaled) {
        if (from instanceof JBDimension) {
            return (JBDimension)from;
        }
        return new JBDimension(from.width, from.height, preScaled);
    }

    @NotNull
    public static JBDimension create(Dimension from) {
        return JBDimension.create(from, false);
    }

    @NotNull
    public JBDimensionUIResource asUIResource() {
        return new JBDimensionUIResource(this);
    }

    @NotNull
    public JBDimension withWidth(int width) {
        JBDimension size = new JBDimension(0, 0);
        size.size2D.set(this.scale(width), this.size2D.height);
        size.set(size.size2D.intWidth(), this.height);
        return size;
    }

    @NotNull
    public JBDimension withHeight(int height) {
        JBDimension size = new JBDimension(0, 0);
        size.size2D.set(this.size2D.width, this.scale(height));
        size.set(this.width, size.size2D.intHeight());
        return size;
    }

    protected void set(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected void set(Size2D size2d) {
        this.set(size2d.intWidth(), size2d.intHeight());
    }

    public boolean update() {
        if (!this.scaler.needUpdate()) {
            return false;
        }
        this.size2D.set(this.scaler.scaleVal(this.size2D.width), this.scaler.scaleVal(this.size2D.height));
        this.set(this.size2D);
        this.scaler.update();
        return true;
    }

    @NotNull
    public JBDimension size() {
        this.update();
        return this;
    }

    @NotNull
    public JBDimension newSize() {
        this.update();
        return new JBDimension(this.size2D.width, this.size2D.height, true);
    }

    public int width() {
        this.update();
        return this.width;
    }

    public int height() {
        this.update();
        return this.height;
    }

    public double width2d() {
        this.update();
        return this.size2D.width;
    }

    public double height2d() {
        this.update();
        return this.size2D.height;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBDimension)) {
            return false;
        }
        JBDimension that = (JBDimension)obj;
        return this.size2D.equals(that.size2D);
    }

    public static class JBDimensionUIResource
    extends JBDimension
    implements UIResource {
        public JBDimensionUIResource(JBDimension size) {
            super(0, 0);
            this.set(size.width, size.height);
            this.size2D = size.size2D.copy();
        }
    }

    private static class Size2D {
        double width;
        double height;

        Size2D(double width, double height) {
            this.width = width;
            this.height = height;
        }

        int intWidth() {
            return (int)Math.ceil(this.width);
        }

        int intHeight() {
            return (int)Math.ceil(this.height);
        }

        Size2D copy() {
            return new Size2D(this.width, this.height);
        }

        void set(double width, double height) {
            this.width = width;
            this.height = height;
        }
    }
}

