/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CopyableIcon;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Function;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.TDoubleObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUI.userScaleFactor";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    private static final LazyInitializer.NotNullValue<Float> SYSTEM_SCALE_FACTOR = new LazyInitializer.NotNullValue<Float>(){

        @Override
        @NotNull
        public Float initialize() {
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                return Float.valueOf(1.0f);
            }
            if (UIUtil.isJreHiDPIEnabled()) {
                GraphicsDevice gd = null;
                try {
                    gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
                if (gd != null && gd.getDefaultConfiguration() != null) {
                    return Float.valueOf(JBUI.sysScale(gd.getDefaultConfiguration()));
                }
                return Float.valueOf(1.0f);
            }
            UIUtil.initSystemFontData();
            Pair<String, Integer> fdata = UIUtil.getSystemFontData();
            int size = fdata == null ? Fonts.label().getSize() : fdata.getSecond().intValue();
            return Float.valueOf(JBUI.getFontScale(size));
        }

        @Override
        protected void onInitialized(@NotNull Float scale) {
            LOG.info("System scale factor: " + scale + " (" + (UIUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        }
    };
    public static final LazyInitializer.NullableValue<Float> DEBUG_USER_SCALE_FACTOR = new LazyInitializer.NullableValue<Float>(){

        @Override
        @Nullable
        public Float initialize() {
            String prop = System.getProperty("ide.ui.scale");
            if (prop != null) {
                try {
                    return Float.valueOf(Float.parseFloat(prop));
                }
                catch (NumberFormatException e) {
                    LOG.error("ide.ui.scale system property is not a float value: " + prop);
                }
            } else if (Registry.is("ide.ui.scale.override")) {
                return Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
            }
            return null;
        }

        @Override
        protected void onInitialized(@Nullable Float scale) {
            if (this.isNotNull()) {
                JBUI.setUserScaleFactor(ObjectUtils.notNull(scale).floatValue());
            }
        }
    };
    private static float userScaleFactor = JBUI.setUserScaleFactor(UIUtil.isJreHiDPIEnabled() ? 1.0f : SYSTEM_SCALE_FACTOR.get().floatValue());
    private static final JBEmptyBorder SHARED_EMPTY_INSTANCE = new JBEmptyBorder(0);

    public static void addPropertyChangeListener(@NotNull String propertyName, @NotNull PropertyChangeListener listener) {
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static void removePropertyChangeListener(@NotNull String propertyName, @NotNull PropertyChangeListener listener) {
        PCS.removePropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        return SYSTEM_SCALE_FACTOR.get().floatValue();
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (UIUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() == 0) {
            if (SystemInfo.isMac && UIUtil.isJreHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return (float)g.getTransform().getScaleX();
            }
            return JBUI.sysScale(gc);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Component comp) {
        if (comp != null) {
            return JBUI.sysScale(comp.getGraphicsConfiguration());
        }
        return JBUI.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext ctx) {
        if (ctx != null) {
            return ctx.getScale(ScaleType.SYS_SCALE);
        }
        return JBUI.sysScale();
    }

    public static float pixScale() {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale() * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc, float f) {
        return JBUI.pixScale(gc) * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(gc) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Graphics2D g) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(g) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Component comp) {
        return JBUI.pixScale(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    public static <T extends BaseScaleContext> double pixScale(@Nullable T ctx) {
        if (ctx != null) {
            double usrScale = ctx.getScale(ScaleType.USR_SCALE);
            return UIUtil.isJreHiDPIEnabled() ? ctx.getScale(ScaleType.SYS_SCALE) * usrScale : usrScale;
        }
        return JBUI.pixScale();
    }

    private static void setUserScaleFactorProperty(float scale) {
        if (userScaleFactor == scale) {
            return;
        }
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, f, Float.valueOf(userScaleFactor));
        LOG.info("User scale factor: " + userScaleFactor);
    }

    public static float setUserScaleFactor(float scale) {
        Float factor = DEBUG_USER_SCALE_FACTOR.get();
        if (factor != null) {
            float debugScale = factor.floatValue();
            if (scale == debugScale) {
                JBUI.setUserScaleFactorProperty(debugScale);
            }
            return debugScale;
        }
        if (!SystemProperties.getBooleanProperty("hidpi", true)) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return 1.0f;
        }
        if ((scale = JBUI.discreteScale(scale)) < 1.0f && JBUI.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfo.isLinux && scale == 1.25f && UIUtil.DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        JBUI.setUserScaleFactorProperty(scale);
        return scale;
    }

    static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i) {
        return Math.round(userScaleFactor * (float)i);
    }

    public static int scaleFontSize(float fontSize) {
        if (userScaleFactor == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (userScaleFactor == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUI.scale(fontSize);
    }

    public static float getFontScale(float fontSize) {
        return fontSize / UIUtil.DEF_SYSTEM_FONT_SIZE;
    }

    @NotNull
    public static JBValue value(float value) {
        return new JBValue.Float(value);
    }

    @NotNull
    public static JBValue uiIntValue(@NotNull String key, int defValue) {
        return new JBValue.UIInteger(key, defValue);
    }

    @NotNull
    public static JBDimension size(int width, int height) {
        return new JBDimension(width, height);
    }

    @NotNull
    public static JBDimension size(int widthAndHeight) {
        return new JBDimension(widthAndHeight, widthAndHeight);
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension newSize = ((JBDimension)size).newSize();
            return size instanceof UIResource ? newSize.asUIResource() : newSize;
        }
        return new JBDimension(size.width, size.height);
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        return new JBInsets(top, left, bottom, right);
    }

    @NotNull
    public static JBInsets insets(int all) {
        return JBUI.insets(all, all, all, all);
    }

    @NotNull
    public static JBInsets insets(String propName, JBInsets defaultValue) {
        Insets i = UIManager.getInsets(propName);
        return i != null ? JBInsets.create(i) : defaultValue;
    }

    @NotNull
    public static JBInsets insets(int topBottom, int leftRight) {
        return JBUI.insets(topBottom, leftRight, topBottom, leftRight);
    }

    @NotNull
    public static JBInsets emptyInsets() {
        return new JBInsets(0, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsTop(int t) {
        return JBUI.insets(t, 0, 0, 0);
    }

    @NotNull
    public static JBInsets insetsLeft(int l) {
        return JBUI.insets(0, l, 0, 0);
    }

    @NotNull
    public static JBInsets insetsBottom(int b) {
        return JBUI.insets(0, 0, b, 0);
    }

    @NotNull
    public static JBInsets insetsRight(int r) {
        return JBUI.insets(0, 0, 0, r);
    }

    @NotNull
    public static <T extends JBIcon> T scale(@NotNull T icon) {
        return (T)icon.withIconPreScaled(false);
    }

    @NotNull
    public static JBDimension emptySize() {
        return new JBDimension(0, 0);
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        return JBInsets.create(insets);
    }

    @Deprecated
    public static boolean isHiDPI() {
        return JBUI.isUsrHiDPI();
    }

    public static boolean isUsrHiDPI() {
        return JBUI.isHiDPI(JBUI.scale(1.0f));
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUI.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Graphics2D g) {
        return JBUI.isHiDPI(JBUI.pixScale(g));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUI.isHiDPI(JBUI.pixScale(comp));
    }

    public static boolean isHiDPI(double scale) {
        return scale > 1.0;
    }

    public static Border asUIResource(@NotNull Border border) {
        if (border instanceof UIResource) {
            return border;
        }
        return new BorderUIResource(border);
    }

    public static int getInt(@NotNull String propertyName, int defaultValue) {
        Object value = UIManager.get(propertyName);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    @NotNull
    private static Icon getIcon(@NotNull String propertyName, @NotNull Icon defaultIcon) {
        Icon icon = UIManager.getIcon(propertyName);
        return icon == null ? defaultIcon : icon;
    }

    @NotNull
    private static Border getBorder(@NotNull String propertyName, @NotNull Border defaultBorder) {
        Border border = UIManager.getBorder(propertyName);
        return border == null ? defaultBorder : border;
    }

    public static class CurrentTheme {

        public static class Link {
            @NotNull
            public static Color linkColor() {
                return JBColor.namedColor("Link.activeForeground", JBColor.namedColor("link.foreground", 5807606));
            }

            @NotNull
            public static Color linkHoverColor() {
                return JBColor.namedColor("Link.hoverForeground", JBColor.namedColor("link.hover.foreground", Link.linkColor()));
            }

            @NotNull
            public static Color linkPressedColor() {
                return JBColor.namedColor("Link.pressedForeground", JBColor.namedColor("link.pressed.foreground", new JBColor(0xF00000, 12218149)));
            }

            @NotNull
            public static Color linkVisitedColor() {
                return JBColor.namedColor("Link.visitedForeground", JBColor.namedColor("link.visited.foreground", new JBColor(0x800080, 9926313)));
            }
        }

        public static class Validator {
            @NotNull
            public static Color errorBorderColor() {
                return JBColor.namedColor("ValidationTooltip.errorBorderColor", 14723241);
            }

            @NotNull
            public static Color errorBackgroundColor() {
                return JBColor.namedColor("ValidationTooltip.errorBackground", JBColor.namedColor("ValidationTooltip.errorBackgroundColor", 16115431));
            }

            @NotNull
            public static Color warningBorderColor() {
                return JBColor.namedColor("ValidationTooltip.warningBorderColor", 14732968);
            }

            @NotNull
            public static Color warningBackgroundColor() {
                return JBColor.namedColor("ValidationTooltip.warningBackground", JBColor.namedColor("ValidationTooltip.warningBackgroundColor", 16117990));
            }
        }

        public static class Advertiser {
            private static final JBInsets DEFAULT_AD_INSETS = JBUI.insets(1, 5);

            @NotNull
            public static Color foreground() {
                Color foreground = BigPopup.advertiserForeground();
                return JBColor.namedColor("Popup.Advertiser.foreground", foreground);
            }

            @NotNull
            public static Color background() {
                Color background = BigPopup.advertiserBackground();
                return JBColor.namedColor("Popup.Advertiser.background", background);
            }

            @NotNull
            public static Border border() {
                return new JBEmptyBorder(JBUI.insets("Popup.Advertiser.borderInsets", DEFAULT_AD_INSETS));
            }

            @NotNull
            public static Color borderColor() {
                return JBColor.namedColor("Popup.Advertiser.borderColor", Gray._135);
            }
        }

        public static class BigPopup {
            @NotNull
            public static Color headerBackground() {
                return JBColor.namedColor("SearchEverywhere.Header.background", 0xF2F2F2);
            }

            @NotNull
            public static Insets tabInsets() {
                return JBUI.insets(0, 12);
            }

            @NotNull
            public static Color selectedTabColor() {
                return JBColor.namedColor("SearchEverywhere.Tab.selectedBackground", 0xDEDEDE);
            }

            @NotNull
            public static Color selectedTabTextColor() {
                return JBColor.namedColor("SearchEverywhere.Tab.selectedForeground", 0);
            }

            @NotNull
            public static Color searchFieldBackground() {
                return JBColor.namedColor("SearchEverywhere.SearchField.background", 0xFFFFFF);
            }

            @NotNull
            public static Color searchFieldBorderColor() {
                return JBColor.namedColor("SearchEverywhere.SearchField.borderColor", 0xBDBDBD);
            }

            @NotNull
            public static Insets searchFieldInsets() {
                return JBUI.insets(0, 6, 0, 5);
            }

            public static int maxListHeight() {
                return JBUI.scale(600);
            }

            @NotNull
            public static Color listSeparatorColor() {
                return JBColor.namedColor("SearchEverywhere.List.separatorColor", Gray.xDC);
            }

            @NotNull
            public static Color listTitleLabelForeground() {
                return JBColor.namedColor("SearchEverywhere.List.separatorForeground", UIUtil.getLabelDisabledForeground());
            }

            @NotNull
            public static Color searchFieldGrayForeground() {
                return JBColor.namedColor("SearchEverywhere.SearchField.infoForeground", JBColor.GRAY);
            }

            @NotNull
            public static Color advertiserForeground() {
                return JBColor.namedColor("SearchEverywhere.Advertiser.foreground", JBColor.GRAY);
            }

            @NotNull
            public static Border advertiserBorder() {
                return new JBEmptyBorder(JBUI.insets("SearchEverywhere.Advertiser.foreground", JBUI.insetsLeft(8)));
            }

            @NotNull
            public static Color advertiserBackground() {
                return JBColor.namedColor("SearchEverywhere.Advertiser.background", 0xF2F2F2);
            }
        }

        public static class TabbedPane {
            public static final Color ENABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.underlineColor", JBColor.namedColor("TabbedPane.selectedColor", 4228041));
            public static final Color DISABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.disabledUnderlineColor", JBColor.namedColor("TabbedPane.selectedDisabledColor", Gray.xAB));
            public static final Color DISABLED_TEXT_COLOR = JBColor.namedColor("TabbedPane.disabledForeground", JBColor.namedColor("TabbedPane.disabledText", Gray.x99));
            public static final Color HOVER_COLOR = JBColor.namedColor("TabbedPane.hoverColor", Gray.xD9);
            public static final Color FOCUS_COLOR = JBColor.namedColor("TabbedPane.focusColor", 14345453);
            public static final JBValue TAB_HEIGHT = new JBValue.UIInteger("TabbedPane.tabHeight", 32);
            public static final JBValue SELECTION_HEIGHT = new JBValue.UIInteger("TabbedPane.tabSelectionHeight", 3);
        }

        public static class Focus {
            private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

            @NotNull
            public static Color focusColor() {
                return UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor("Component.focusColor", JBColor.namedColor("Focus.borderColor", 9089771));
            }

            @NotNull
            public static Color defaultButtonColor() {
                return UIUtil.isUnderDarcula() ? JBColor.namedColor("Button.default.focusColor", JBColor.namedColor("Focus.defaultButtonBorderColor", 9946099)) : Focus.focusColor();
            }

            @NotNull
            public static Color errorColor(boolean active) {
                return active ? JBColor.namedColor("Component.errorFocusColor", JBColor.namedColor("Focus.activeErrorBorderColor", 15023693)) : JBColor.namedColor("Component.inactiveErrorFocusColor", JBColor.namedColor("Focus.inactiveErrorBorderColor", 0xEBBCBC));
            }

            @NotNull
            public static Color warningColor(boolean active) {
                return active ? JBColor.namedColor("Component.warningFocusColor", JBColor.namedColor("Focus.activeWarningBorderColor", 14853434)) : JBColor.namedColor("Component.inactiveWarningFocusColor", JBColor.namedColor("Focus.inactiveWarningBorderColor", 16765829));
            }
        }

        public static class Popup {
            public static Color headerBackground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeBackground", 0xE6E6E6) : JBColor.namedColor("Popup.Header.inactiveBackground", 0xEDEDED);
            }

            public static int headerHeight(boolean hasControls) {
                return hasControls ? JBUI.scale(28) : JBUI.scale(24);
            }

            public static Color borderColor(boolean active) {
                return active ? JBColor.namedColor("Popup.borderColor", JBColor.namedColor("Popup.Border.color", 0x808080)) : JBColor.namedColor("Popup.inactiveBorderColor", JBColor.namedColor("Popup.inactiveBorderColor", 0xAAAAAA));
            }

            public static Color toolbarPanelColor() {
                return JBColor.namedColor("Popup.Toolbar.background", 0xF7F7F7);
            }

            public static Color toolbarBorderColor() {
                return JBColor.namedColor("Popup.Toolbar.borderColor", JBColor.namedColor("Popup.Toolbar.Border.color", 0xF7F7F7));
            }

            public static int toolbarHeight() {
                return JBUI.scale(28);
            }

            public static Color separatorColor() {
                return JBColor.namedColor("Popup.separatorColor", new JBColor(Color.gray.brighter(), Gray.x51));
            }

            public static Color separatorTextColor() {
                return JBColor.namedColor("Popup.separatorForeground", Color.gray);
            }
        }

        public static class Label {
            @NotNull
            public static Color foreground(boolean selected) {
                return selected ? JBColor.namedColor("Label.selectedForeground", 0xFFFFFF) : JBColor.namedColor("Label.foreground", 0);
            }

            @NotNull
            public static Color foreground() {
                return Label.foreground(false);
            }

            @NotNull
            public static Color disabledForeground(boolean selected) {
                return selected ? JBColor.namedColor("Label.selectedDisabledForeground", 0x999999) : JBColor.namedColor("Label.disabledForeground", JBColor.namedColor("Label.disabledText", 0x999999));
            }

            @NotNull
            public static Color disabledForeground() {
                return Label.disabledForeground(false);
            }
        }

        public static class ToolWindow {
            @NotNull
            public static Color tabSelectedBackground() {
                return Registry.is("toolwindow.active.tab.use.contrast.background") ? Registry.getColor("toolwindow.active.tab.contrast.background.color", JBColor.GRAY) : JBColor.namedColor("ToolWindow.HeaderTab.selectedInactiveBackground", JBColor.namedColor("ToolWindow.header.tab.selected.background", 0xDEDEDE));
            }

            @NotNull
            public static Color tabSelectedActiveBackground() {
                return Registry.is("toolwindow.active.tab.use.contrast.background") ? Registry.getColor("toolwindow.active.tab.contrast.background.color", JBColor.GRAY) : JBColor.namedColor("ToolWindow.HeaderTab.selectedBackground", JBColor.namedColor("ToolWindow.header.tab.selected.active.background", 13685976));
            }

            @NotNull
            public static Color tabHoveredBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverInactiveBackground", JBColor.namedColor("ToolWindow.header.tab.hovered.background", ToolWindow.tabSelectedBackground()));
            }

            @NotNull
            public static Color tabHoveredActiveBackground() {
                return JBColor.namedColor("ToolWindow.HeaderTab.hoverBackground", JBColor.namedColor("ToolWindow.header.tab.hovered.active.background", ToolWindow.tabSelectedActiveBackground()));
            }

            @NotNull
            public static Color tabSelectedBackground(boolean active) {
                return active ? ToolWindow.tabSelectedActiveBackground() : ToolWindow.tabSelectedBackground();
            }

            @NotNull
            public static Color tabHoveredBackground(boolean active) {
                return active ? ToolWindow.tabHoveredActiveBackground() : ToolWindow.tabHoveredBackground();
            }

            @NotNull
            public static Color headerBackground(boolean active) {
                return active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
            }

            @NotNull
            public static Color headerBackground() {
                return JBColor.namedColor("ToolWindow.Header.inactiveBackground", JBColor.namedColor("ToolWindow.header.background", 0xECECEC));
            }

            @NotNull
            public static Color headerBorderBackground() {
                return JBColor.namedColor("ToolWindow.Header.borderColor", JBColor.namedColor("ToolWindow.header.border.background", 0xC9C9C9));
            }

            @NotNull
            public static Color headerActiveBackground() {
                return JBColor.namedColor("ToolWindow.Header.background", JBColor.namedColor("ToolWindow.header.active.background", 14870252));
            }

            public static int tabVerticalPadding() {
                return JBUI.getInt("ToolWindow.tab.verticalPadding", 0);
            }

            @NotNull
            public static Border tabBorder() {
                return JBUI.getBorder("ToolWindow.tabBorder", Borders.empty(1));
            }

            @NotNull
            public static Font headerFont() {
                JBFont font = Fonts.label();
                Object size = UIManager.get("ToolWindow.header.font.size");
                if (size instanceof Integer) {
                    return font.deriveFont(((Integer)size).floatValue());
                }
                return font;
            }

            public static float overrideHeaderFontSizeOffset() {
                Object offset = UIManager.get("ToolWindow.overridden.header.font.size.offset");
                if (offset instanceof Integer) {
                    return ((Integer)offset).floatValue();
                }
                return 0.0f;
            }

            @NotNull
            public static Color hoveredIconBackground() {
                return JBColor.namedColor("ToolWindow.HeaderCloseButton.background", JBColor.namedColor("ToolWindow.header.closeButton.background", 0xB9B9B9));
            }

            @NotNull
            public static Icon closeTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.Close);
            }

            @NotNull
            public static Icon comboTabIcon(boolean hovered) {
                return hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ArrowDown) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ArrowDown);
            }
        }

        public static class CustomFrameDecorations {
            @NotNull
            public static Color separatorForeground() {
                return JBColor.namedColor("Separator.separatorColor", new JBColor(0xCDCDCD, 0x515151));
            }

            @NotNull
            public static Color titlePaneBackground() {
                return JBColor.namedColor("TitlePane.background", CustomFrameDecorations.paneBackground());
            }

            @NotNull
            public static Color titlePaneInfoForeground() {
                return JBColor.namedColor("TitlePane.infoForeground", new JBColor(0x595959, 0x999999));
            }

            @NotNull
            public static Color titlePaneInactiveInfoForeground() {
                return JBColor.namedColor("TitlePane.inactiveInfoForeground", new JBColor(0xB1B1B1, 0x737373));
            }

            @NotNull
            public static Color paneBackground() {
                return JBColor.namedColor("Panel.background", 0xCDCDCD);
            }
        }

        public static class ActionButton {
            @NotNull
            public static Color pressedBackground() {
                return JBColor.namedColor("ActionButton.pressedBackground", Gray.xCF);
            }

            @NotNull
            public static Color pressedBorder() {
                return JBColor.namedColor("ActionButton.pressedBorderColor", Gray.xCF);
            }

            @NotNull
            public static Color hoverBackground() {
                return JBColor.namedColor("ActionButton.hoverBackground", Gray.xDF);
            }

            @NotNull
            public static Color hoverBorder() {
                return JBColor.namedColor("ActionButton.hoverBorderColor", Gray.xDF);
            }

            @NotNull
            public static Color hoverSeparatorColor() {
                return JBColor.namedColor("ActionButton.hoverSeparatorColor", new JBColor(Gray.xB3, Gray.x6B));
            }
        }
    }

    public static abstract class RasterJBIcon
    extends ScaleContextSupport<ScaleContext>
    implements CopyableIcon {
        public RasterJBIcon() {
            super(ScaleContext.create());
        }
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon
    implements CopyableIcon {
        private T myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(@NotNull CachingScalableJBIcon icon) {
            super(icon);
        }

        @NotNull
        public T scale(float scale) {
            if (scale == this.getScale()) {
                return (T)this;
            }
            if (this.myScaledIconCache == null || ((ScalableJBIcon)this.myScaledIconCache).getScale() != scale) {
                this.myScaledIconCache = this.copy();
                ((ScaleContextSupport)this.myScaledIconCache).updateScale(ScaleType.OBJ_SCALE.of(scale));
            }
            return this.myScaledIconCache;
        }

        @NotNull
        public abstract T copy();
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(@NotNull ScalableJBIcon icon) {
            super(icon);
        }

        @Override
        public float getScale() {
            return (float)this.getScale(ScaleType.OBJ_SCALE);
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            this.updateScale(ScaleType.OBJ_SCALE.of(scale));
            return this;
        }

        @Override
        protected double scaleVal(double value) {
            return this.scaleVal(value, ScaleType.PIX_SCALE);
        }

        protected double scaleVal(double value, @NotNull ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return super.scaleVal(value);
                }
                case SYS_SCALE: {
                    return value * this.getScale(ScaleType.SYS_SCALE);
                }
                case OBJ_SCALE: {
                    return value * this.getScale(ScaleType.OBJ_SCALE);
                }
                case PIX_SCALE: {
                    return super.scaleVal(value * this.getScale(ScaleType.OBJ_SCALE));
                }
            }
            return value;
        }
    }

    public static abstract class JBIcon
    extends ScaleContextSupport<BaseScaleContext>
    implements Icon {
        private final Scaler myScaler = new Scaler(){

            @Override
            protected double currentScale() {
                if (autoUpdateScaleContext) {
                    ((BaseScaleContext)this.getScaleContext()).update();
                }
                return this.getScale(ScaleType.USR_SCALE);
            }
        };
        private boolean autoUpdateScaleContext = true;

        protected JBIcon() {
            super(BaseScaleContext.create());
        }

        protected JBIcon(@NotNull JBIcon icon) {
            this();
            this.updateScaleContext((BaseScaleContext)icon.getScaleContext());
            this.myScaler.update(icon.myScaler);
            this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
        }

        protected boolean isIconPreScaled() {
            return this.myScaler.isPreScaled();
        }

        protected void setIconPreScaled(boolean preScaled) {
            this.myScaler.setPreScaled(preScaled);
        }

        @NotNull
        public JBIcon withIconPreScaled(boolean preScaled) {
            this.setIconPreScaled(preScaled);
            return this;
        }

        protected double scaleVal(double value) {
            return this.myScaler.scaleVal(value);
        }

        protected void setAutoUpdateScaleContext(boolean autoUpdate) {
            this.autoUpdateScaleContext = autoUpdate;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
        }
    }

    public static class ScaleContextSupport<T extends BaseScaleContext>
    implements ScaleContextAware {
        @NotNull
        private final T myScaleContext;

        public ScaleContextSupport(@NotNull T ctx) {
            this.myScaleContext = ctx;
        }

        @NotNull
        public T getScaleContext() {
            return this.myScaleContext;
        }

        @Override
        public boolean updateScaleContext(@Nullable BaseScaleContext ctx) {
            return ((BaseScaleContext)this.myScaleContext).update(ctx);
        }

        @Override
        public double getScale(@NotNull ScaleType type) {
            return ((BaseScaleContext)this.getScaleContext()).getScale(type);
        }

        @Override
        public boolean updateScale(@NotNull Scale scale) {
            return ((BaseScaleContext)this.getScaleContext()).update(scale);
        }
    }

    public static interface ScaleContextAware {
        @NotNull
        public BaseScaleContext getScaleContext();

        public boolean updateScaleContext(@Nullable BaseScaleContext var1);

        public double getScale(@NotNull ScaleType var1);

        public boolean updateScale(@NotNull Scale var1);
    }

    public static class ScaleContext
    extends BaseScaleContext {
        protected Scale sysScale = ScaleType.SYS_SCALE.of(JBUI.sysScale());
        @Nullable
        private WeakReference<Component> compRef;

        private ScaleContext() {
            this.pixScale = this.derivePixScale();
        }

        private ScaleContext(@NotNull Scale scale) {
            this();
            this.update(scale);
        }

        @NotNull
        public static ScaleContext createIdentity() {
            return ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
        }

        @NotNull
        public static ScaleContext create(@Nullable BaseScaleContext ctx) {
            ScaleContext c = ScaleContext.createIdentity();
            c.update(ctx);
            return c;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component comp) {
            ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp)));
            if (comp != null) {
                ctx.compRef = new WeakReference<Component>(comp);
            }
            return ctx;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component component, @Nullable Graphics2D graphics) {
            return ScaleContext.create(graphics);
        }

        @NotNull
        public static ScaleContext create(@Nullable GraphicsConfiguration gc) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(gc)));
        }

        @NotNull
        public static ScaleContext create(Graphics2D g) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(g)));
        }

        @NotNull
        public static ScaleContext create(@NotNull Scale scale) {
            return new ScaleContext(scale);
        }

        @NotNull
        public static ScaleContext create(Scale ... scales) {
            ScaleContext ctx = ScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            return ctx;
        }

        @NotNull
        public static ScaleContext create() {
            return new ScaleContext();
        }

        @Override
        protected double derivePixScale() {
            return UIUtil.isJreHiDPIEnabled() ? this.sysScale.value * super.derivePixScale() : super.derivePixScale();
        }

        @Override
        public double getScale(@NotNull ScaleType type) {
            if (type == ScaleType.SYS_SCALE) {
                return this.sysScale.value;
            }
            return super.getScale(type);
        }

        @Override
        public boolean update() {
            Component comp;
            boolean updated = this.update(ScaleType.USR_SCALE.of(JBUI.scale(1.0f)));
            if (this.compRef != null && (comp = (Component)this.compRef.get()) != null) {
                updated = this.update(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp))) || updated;
            }
            return this.onUpdated(updated);
        }

        @Override
        public boolean update(@NotNull Scale scale) {
            if (this.isScaleOverridden(scale)) {
                return false;
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                boolean updated = !this.sysScale.equals(scale);
                this.sysScale = scale;
                return this.onUpdated(updated);
            }
            return super.update(scale);
        }

        @Override
        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            boolean updated = super.updateAll(ctx);
            if (!(ctx instanceof ScaleContext)) {
                return updated;
            }
            ScaleContext context = (ScaleContext)ctx;
            if (this.compRef != null) {
                this.compRef.clear();
            }
            this.compRef = context.compRef;
            return this.update(context.sysScale) || updated;
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScaleContext) {
                ScaleContext that = (ScaleContext)obj;
                return that.sysScale.value == this.sysScale.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Double.valueOf(this.sysScale.value).hashCode() * 100 + super.hashCode();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.compRef != null) {
                this.compRef.clear();
            }
        }

        @Override
        @NotNull
        public <T extends BaseScaleContext> T copy() {
            ScaleContext ctx = ScaleContext.createIdentity();
            ctx.updateAll(this);
            return (T)ctx;
        }

        @Override
        public String toString() {
            return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
        }

        public static class Cache<D>
        extends BaseScaleContext.Cache<D, ScaleContext> {
            public Cache(@NotNull Function<? super ScaleContext, ? extends D> dataProvider) {
                super(dataProvider);
            }
        }
    }

    public static class BaseScaleContext {
        protected Scale usrScale = ScaleType.USR_SCALE.of(JBUI.scale(1.0f));
        protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
        protected double pixScale = Scale.access$200(this.usrScale);
        private List<UpdateListener> listeners;
        private EnumSet<ScaleType> overriddenScales;

        private BaseScaleContext() {
        }

        @NotNull
        public static BaseScaleContext createIdentity() {
            return BaseScaleContext.create(ScaleType.USR_SCALE.of(1.0));
        }

        @NotNull
        public static BaseScaleContext create(Scale ... scales) {
            BaseScaleContext ctx = BaseScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            return ctx;
        }

        @NotNull
        public static BaseScaleContext create() {
            return new BaseScaleContext();
        }

        @NotNull
        public static BaseScaleContext create(@Nullable BaseScaleContext ctx) {
            BaseScaleContext c = BaseScaleContext.createIdentity();
            c.update(ctx);
            return c;
        }

        protected double derivePixScale() {
            return this.usrScale.value * this.objScale.value;
        }

        public boolean overrideScale(@NotNull Scale scale) {
            if (this.overriddenScales != null) {
                this.overriddenScales.remove((Object)scale.type);
            }
            boolean updated = this.update(scale);
            if (this.overriddenScales == null) {
                this.overriddenScales = EnumSet.of(scale.type);
            } else {
                this.overriddenScales.add(scale.type);
            }
            return updated;
        }

        protected boolean isScaleOverridden(@NotNull Scale scale) {
            return this.overriddenScales != null && this.overriddenScales.contains((Object)scale.type);
        }

        public double getScale(@NotNull ScaleType type) {
            switch (type) {
                case USR_SCALE: {
                    return this.usrScale.value;
                }
                case SYS_SCALE: {
                    return 1.0;
                }
                case OBJ_SCALE: {
                    return this.objScale.value;
                }
                case PIX_SCALE: {
                    return this.pixScale;
                }
            }
            return 1.0;
        }

        public double apply(double value, ScaleType ... types) {
            for (ScaleType t : types) {
                value *= this.getScale(t);
            }
            return value;
        }

        public double apply(double value) {
            return value * this.getScale(ScaleType.PIX_SCALE);
        }

        protected boolean onUpdated(boolean updated) {
            if (updated) {
                this.pixScale = this.derivePixScale();
                this.notifyUpdateListeners();
            }
            return updated;
        }

        public boolean update() {
            return this.onUpdated(this.update(ScaleType.USR_SCALE.of(JBUI.scale(1.0f))));
        }

        public boolean update(@NotNull Scale scale) {
            if (this.isScaleOverridden(scale)) {
                return false;
            }
            boolean updated = false;
            switch (scale.type) {
                case USR_SCALE: {
                    updated = !this.usrScale.equals(scale);
                    this.usrScale = scale;
                    break;
                }
                case OBJ_SCALE: {
                    updated = !this.objScale.equals(scale);
                    this.objScale = scale;
                    break;
                }
                case SYS_SCALE: {
                    return false;
                }
            }
            return this.onUpdated(updated);
        }

        public boolean update(@Nullable BaseScaleContext ctx) {
            if (ctx == null) {
                return this.update();
            }
            return this.onUpdated(this.updateAll(ctx));
        }

        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            boolean updated = this.update(ctx.usrScale);
            return this.update(ctx.objScale) || updated;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BaseScaleContext)) {
                return false;
            }
            BaseScaleContext that = (BaseScaleContext)obj;
            return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
        }

        public int hashCode() {
            return BaseScaleContext.hash(this.usrScale.value) * 31 + BaseScaleContext.hash(this.objScale.value);
        }

        private static int hash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }

        public void dispose() {
            this.listeners = null;
        }

        public void addUpdateListener(@NotNull UpdateListener l) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<UpdateListener>(1);
            }
            this.listeners.add(l);
        }

        public void removeUpdateListener(@NotNull UpdateListener l) {
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        protected void notifyUpdateListeners() {
            if (this.listeners == null) {
                return;
            }
            for (UpdateListener l : this.listeners) {
                l.contextUpdated();
            }
        }

        @NotNull
        public <T extends BaseScaleContext> T copy() {
            BaseScaleContext ctx = BaseScaleContext.createIdentity();
            ctx.updateAll(this);
            return (T)ctx;
        }

        public String toString() {
            return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
        }

        public static class Cache<D, S extends BaseScaleContext> {
            private final Function<? super S, ? extends D> myDataProvider;
            private final AtomicReference<Pair<Double, D>> myData = new AtomicReference<Object>(null);

            public Cache(@NotNull Function<? super S, ? extends D> dataProvider) {
                this.myDataProvider = dataProvider;
            }

            @Nullable
            public D getOrProvide(@NotNull S ctx) {
                Pair<Double, D> data = this.myData.get();
                double scale = ((BaseScaleContext)ctx).getScale(ScaleType.PIX_SCALE);
                if (data == null || Double.compare(scale, (Double)data.first) != 0) {
                    data = Pair.create(scale, this.myDataProvider.fun(ctx));
                    this.myData.set(data);
                }
                return (D)data.second;
            }

            public void clear() {
                this.myData.set(null);
            }
        }

        public static interface UpdateListener {
            public void contextUpdated();
        }
    }

    public static abstract class Scaler {
        protected double initialScale = this.currentScale();

        private double alignedScale() {
            return this.currentScale() / this.initialScale;
        }

        protected boolean isPreScaled() {
            return this.initialScale != 1.0;
        }

        protected void setPreScaled(boolean preScaled) {
            this.initialScale = preScaled ? this.currentScale() : 1.0;
        }

        public double scaleVal(double value) {
            return value * this.alignedScale();
        }

        protected abstract double currentScale();

        public boolean update(@NotNull Scaler scaler) {
            boolean updated = this.initialScale != scaler.initialScale;
            this.initialScale = scaler.initialScale;
            return updated;
        }
    }

    public static class Panels {
        @NotNull
        public static BorderLayoutPanel simplePanel() {
            return new BorderLayoutPanel();
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(Component comp) {
            return Panels.simplePanel().addToCenter(comp);
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            return new BorderLayoutPanel(hgap, vgap);
        }
    }

    public static class Borders {
        @NotNull
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                return SHARED_EMPTY_INSTANCE;
            }
            return new JBEmptyBorder(top, left, bottom, right);
        }

        @NotNull
        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            return Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
        }

        @NotNull
        public static JBEmptyBorder emptyTop(int offset) {
            return Borders.empty(offset, 0, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyLeft(int offset) {
            return Borders.empty(0, offset, 0, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyBottom(int offset) {
            return Borders.empty(0, 0, offset, 0);
        }

        @NotNull
        public static JBEmptyBorder emptyRight(int offset) {
            return Borders.empty(0, 0, 0, offset);
        }

        @NotNull
        public static JBEmptyBorder empty() {
            return Borders.empty(0, 0, 0, 0);
        }

        @NotNull
        public static Border empty(int offsets) {
            return Borders.empty(offsets, offsets, offsets, offsets);
        }

        @NotNull
        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            return new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
        }

        @NotNull
        public static Border customLine(Color color, int thickness) {
            return Borders.customLine(color, thickness, thickness, thickness, thickness);
        }

        @NotNull
        public static Border customLine(Color color) {
            return Borders.customLine(color, 1);
        }

        @NotNull
        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (source == null) {
                return extra;
            }
            return new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
        }
    }

    public static class Fonts {
        @NotNull
        public static JBFont label() {
            return JBFont.create(UIManager.getFont("Label.font"), false);
        }

        @NotNull
        public static JBFont label(float size) {
            return Fonts.label().deriveFont(JBUI.scale(size));
        }

        @NotNull
        public static JBFont smallFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
        }

        @NotNull
        public static JBFont miniFont() {
            return Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
        }

        @NotNull
        public static JBFont create(String fontFamily, int size) {
            return JBFont.create(new Font(fontFamily, 0, size));
        }

        @NotNull
        public static JBFont toolbarFont() {
            return SystemInfo.isMac ? Fonts.smallFont() : Fonts.label();
        }

        @NotNull
        public static JBFont toolbarSmallComboBoxFont() {
            return Fonts.label(11.0f);
        }
    }

    public static class Scale {
        private final double value;
        private final ScaleType type;
        private static final ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>> cache = ThreadLocal.withInitial(() -> new EnumMap(ScaleType.class));

        @NotNull
        public static Scale create(double value, @NotNull ScaleType type) {
            Scale scale;
            EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> emap = cache.get();
            TDoubleObjectHashMap map = emap.get((Object)type);
            if (map == null) {
                map = new TDoubleObjectHashMap();
                emap.put(type, (TDoubleObjectHashMap<Scale>)map);
            }
            if ((scale = (Scale)map.get(value)) != null) {
                return scale;
            }
            scale = new Scale(value, type);
            map.put(value, (Object)scale);
            return scale;
        }

        private Scale(double value, @NotNull ScaleType type) {
            this.value = value;
            this.type = type;
        }

        public double value() {
            return this.value;
        }

        @NotNull
        public ScaleType type() {
            return this.type;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return "[" + this.type.name() + " " + this.value + "]";
        }
    }

    public static enum ScaleType {
        USR_SCALE,
        SYS_SCALE,
        OBJ_SCALE,
        PIX_SCALE;


        @NotNull
        public Scale of(double value) {
            return Scale.create(value, this);
        }
    }
}

