/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessBridgeUtil {
    private static final Logger LOG = Logger.getInstance("#" + AccessBridgeUtil.class.getName());
    private static final String ACCESS_BRIDGE_CLASS_NAME = "com.sun.java.accessibility.AccessBridge";
    private static InstanceMethodEntry ourFocusGainedMethod;

    public static void sendFocusGainedEvent(@Nullable Component focusOwner) {
        if (focusOwner == null) {
            return;
        }
        if (ourFocusGainedMethod == null) {
            ourFocusGainedMethod = AccessBridgeUtil.createFocusGainedMethod();
        }
        try {
            FocusEvent event = new FocusEvent(focusOwner, 1004, false, null);
            ourFocusGainedMethod.invoke(event);
        }
        catch (Throwable e) {
            LOG.warn("Unexpected error invoking focusGained on the AccessBridge class", e);
        }
    }

    @NotNull
    private static InstanceMethodEntry createFocusGainedMethod() {
        Class accessBridgeClass = AccessBridgeUtil.findAccessBridgeClass();
        if (accessBridgeClass == null) {
            return InstanceMethodEntry.Empty;
        }
        try {
            Field theAccessBridgeField = ReflectionUtil.findField(accessBridgeClass, null, "theAccessBridge");
            Object theAccessBridge = theAccessBridgeField.get(null);
            if (theAccessBridge == null) {
                return InstanceMethodEntry.Empty;
            }
            Field eventHandlerField = ReflectionUtil.findField(accessBridgeClass, null, "eventHandler");
            Object eventHandler = eventHandlerField.get(theAccessBridge);
            Method method = ReflectionUtil.getMethod(eventHandler.getClass(), "focusGained", FocusEvent.class);
            return new InstanceMethodEntry(eventHandler, method);
        }
        catch (Throwable e) {
            LOG.warn("Unexpected error looking for the AccessBridge class", e);
            return InstanceMethodEntry.Empty;
        }
    }

    @Nullable
    private static Class findAccessBridgeClass() {
        Method findLoadedClass = ReflectionUtil.getDeclaredMethod(ClassLoader.class, "findLoadedClass", String.class);
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            try {
                Class cls = (Class)findLoadedClass.invoke((Object)cl, ACCESS_BRIDGE_CLASS_NAME);
                if (cls == null) continue;
                return cls;
            }
            catch (Throwable e) {
                LOG.warn("Unexpected error looking for the AccessBridge class", e);
            }
        }
        return null;
    }

    private static class InstanceMethodEntry {
        public static final InstanceMethodEntry Empty = new InstanceMethodEntry(null, null);
        private final Object myInstance;
        private final Method myMethod;

        public InstanceMethodEntry(@Nullable Object instance, @Nullable Method method) {
            this.myInstance = instance;
            this.myMethod = method;
        }

        public void invoke(@NotNull FocusEvent event) throws InvocationTargetException, IllegalAccessException {
            if (this.myMethod == null) {
                return;
            }
            this.myMethod.invoke(this.myInstance, event);
        }
    }
}

