/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ScreenReader {
    public static final String ATK_WRAPPER = "org.GNOME.Accessibility.AtkWrapper";
    public static final String ACCESS_BRIDGE = "com.sun.java.accessibility.AccessBridge";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new ScreenReader());
    public static final String SCREEN_READER_ACTIVE_PROPERTY = "ScreenReader.active";
    private static boolean myActive = false;

    public static boolean isActive() {
        return myActive;
    }

    public static void setActive(boolean active) {
        boolean oldValue = myActive;
        myActive = active;
        PCS.firePropertyChange(SCREEN_READER_ACTIVE_PROPERTY, oldValue, active);
    }

    public static boolean isEnabled(String a11yClassName) {
        String[] paths = new String[]{System.getProperty("user.home") + File.separator + ".accessibility.properties", System.getProperty("java.home") + File.separator + "lib" + File.separator + "accessibility.properties"};
        Properties properties = new Properties();
        for (String path : paths) {
            try (FileInputStream in = new FileInputStream(new File(path));){
                properties.load(in);
            }
            catch (Exception ignore) {
                continue;
            }
            if (!properties.isEmpty()) break;
        }
        if (!properties.isEmpty()) {
            String classNames = System.getProperty("javax.accessibility.assistive_technologies");
            if (classNames == null) {
                classNames = properties.getProperty("assistive_technologies", null);
            }
            if (classNames != null && classNames.contains(a11yClassName)) {
                return true;
            }
        }
        return false;
    }

    public static void addPropertyChangeListener(final @NotNull String propertyName, @NotNull Disposable parent, final @NotNull PropertyChangeListener listener) {
        PCS.addPropertyChangeListener(propertyName, listener);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                PCS.removePropertyChangeListener(propertyName, listener);
            }
        });
    }
}

