/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.components;

import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.accessibility.AccessibleContext;
import org.jetbrains.annotations.NotNull;

public class BorderLayoutPanel
extends JBPanel<BorderLayoutPanel> {
    private boolean myDelegateAccessibleContext;

    public BorderLayoutPanel() {
        this(0, 0);
    }

    public BorderLayoutPanel(int hgap, int vgap) {
        super(new BorderLayout(JBUI.scale(hgap), JBUI.scale(vgap)));
    }

    @NotNull
    public BorderLayoutPanel addToCenter(@NotNull Component comp) {
        this.add(comp, "Center");
        return this;
    }

    @NotNull
    public BorderLayoutPanel addToRight(@NotNull Component comp) {
        this.add(comp, "East");
        return this;
    }

    @NotNull
    public BorderLayoutPanel addToLeft(@NotNull Component comp) {
        this.add(comp, "West");
        return this;
    }

    @NotNull
    public BorderLayoutPanel addToTop(@NotNull Component comp) {
        this.add(comp, "North");
        return this;
    }

    @NotNull
    public BorderLayoutPanel addToBottom(@NotNull Component comp) {
        this.add(comp, "South");
        return this;
    }

    public void setDelegateAccessibleContextToWrappedComponent(boolean delegateAccessibleContext) {
        if (delegateAccessibleContext != this.myDelegateAccessibleContext) {
            this.accessibleContext = null;
        }
        this.myDelegateAccessibleContext = delegateAccessibleContext;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        AccessibleContext context;
        if (this.accessibleContext == null && this.myDelegateAccessibleContext && this.getComponentCount() == 1 && (context = this.getComponent(0).getAccessibleContext()) != null) {
            this.accessibleContext = new MyAccessibleContextDelegate(context);
        }
        return super.getAccessibleContext();
    }

    private class MyAccessibleContextDelegate
    extends AccessibleContextDelegate {
        MyAccessibleContextDelegate(AccessibleContext context) {
            super(context);
        }

        @Override
        public Container getDelegateParent() {
            return BorderLayoutPanel.this.getParent();
        }
    }
}

