/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jetbrains.annotations.NotNull;

public final class TreeModelListenerList
implements TreeModelListener {
    private final List<TreeModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void add(@NotNull TreeModelListener listener) {
        this.myListeners.add(0, listener);
    }

    public void remove(@NotNull TreeModelListener listener) {
        this.myListeners.remove(listener);
    }

    public void clear() {
        this.myListeners.clear();
    }

    public boolean isEmpty() {
        return this.myListeners.isEmpty();
    }

    @Override
    public void treeStructureChanged(@NotNull TreeModelEvent event) {
        for (TreeModelListener listener : this.myListeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public void treeNodesChanged(@NotNull TreeModelEvent event) {
        for (TreeModelListener listener : this.myListeners) {
            listener.treeNodesChanged(event);
        }
    }

    @Override
    public void treeNodesInserted(@NotNull TreeModelEvent event) {
        for (TreeModelListener listener : this.myListeners) {
            listener.treeNodesInserted(event);
        }
    }

    @Override
    public void treeNodesRemoved(@NotNull TreeModelEvent event) {
        for (TreeModelListener listener : this.myListeners) {
            listener.treeNodesRemoved(event);
        }
    }
}

