/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.AccessorBindingWrapper;
import com.intellij.util.xmlb.AttributeBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.FieldAccessor;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.OptionTagBinding;
import com.intellij.util.xmlb.PropertyAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.TagBinding;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.TObjectFloatHashMap;
import java.awt.Rectangle;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeanBinding
extends NotNullDeserializeBinding {
    private static final Map<Class, List<MutableAccessor>> ourAccessorCache = ContainerUtil.newConcurrentMap();
    private final String myTagName;
    protected Binding[] myBindings;
    protected final Class<?> myBeanClass;
    ThreeState compareByFields = ThreeState.UNSURE;

    public BeanBinding(@NotNull Class<?> beanClass, @Nullable MutableAccessor accessor) {
        super(accessor);
        assert (!beanClass.isArray()) : "Bean is an array: " + beanClass;
        assert (!beanClass.isPrimitive()) : "Bean is primitive type: " + beanClass;
        this.myBeanClass = beanClass;
        this.myTagName = BeanBinding.getTagName(beanClass);
        assert (!StringUtil.isEmptyOrSpaces(this.myTagName)) : "Bean name is empty: " + beanClass;
    }

    @Override
    public final synchronized void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        assert (this.myBindings == null);
        Property classAnnotation = this.myBeanClass.getAnnotation(Property.class);
        List<MutableAccessor> accessors = BeanBinding.getAccessors(this.myBeanClass);
        this.myBindings = new Binding[accessors.size()];
        int size = accessors.size();
        for (int i = 0; i < size; ++i) {
            Binding binding = BeanBinding.createBinding(accessors.get(i), serializer, classAnnotation == null ? Property.Style.OPTION_TAG : classAnnotation.style());
            binding.init(originalType, serializer);
            this.myBindings[i] = binding;
        }
    }

    @Override
    @Nullable
    public final Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        return this.serializeInto(o, context == null ? null : new Element(this.myTagName), filter);
    }

    public final Element serialize(@NotNull Object object, boolean createElementIfEmpty, @Nullable SerializationFilter filter) {
        return this.serializeInto(object, createElementIfEmpty ? new Element(this.myTagName) : null, filter);
    }

    @Nullable
    public Element serializeInto(@NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter) {
        for (Binding binding : this.myBindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (o instanceof SerializationFilter && !((SerializationFilter)o).accepts(accessor, o)) continue;
            element = this.serializePropertyInto(binding, o, element, filter, true);
        }
        return element;
    }

    @Nullable
    protected final Element serializePropertyInto(@NotNull Binding binding, @NotNull Object o, @Nullable Element element, @Nullable SerializationFilter filter, boolean isFilterPropertyItself) {
        Object node;
        MutableAccessor accessor = binding.getAccessor();
        Property property = accessor.getAnnotation(Property.class);
        if (property == null || !property.alwaysWrite()) {
            if (filter != null && isFilterPropertyItself && (filter instanceof SkipDefaultsSerializationFilter ? ((SkipDefaultsSerializationFilter)filter).equal(binding, o) : !filter.accepts(accessor, o))) {
                return element;
            }
            if (property != null && property.filter() != SerializationFilter.class && !ReflectionUtil.newInstance(property.filter()).accepts(accessor, o)) {
                return element;
            }
        }
        if (element == null) {
            element = new Element(this.myTagName);
        }
        if ((node = binding.serialize(o, element, filter)) != null) {
            if (node instanceof org.jdom.Attribute) {
                element.setAttribute((org.jdom.Attribute)node);
            } else {
                BeanBinding.addContent(element, node);
            }
        }
        return element;
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        Object instance = ReflectionUtil.newInstance(this.myBeanClass);
        this.deserializeInto(instance, element);
        return instance;
    }

    final boolean equalByFields(@NotNull Object currentValue, @NotNull Object defaultValue, @NotNull SkipDefaultsSerializationFilter filter) {
        for (Binding binding : this.myBindings) {
            MutableAccessor accessor = binding.getAccessor();
            if (filter.equal(binding, accessor.read(currentValue), accessor.read(defaultValue))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final TObjectFloatHashMap<String> computeBindingWeights(@NotNull LinkedHashSet<String> accessorNameTracker) {
        TObjectFloatHashMap weights = new TObjectFloatHashMap(accessorNameTracker.size());
        float weight = 0.0f;
        float step = (float)this.myBindings.length / (float)accessorNameTracker.size();
        for (String name : accessorNameTracker) {
            weights.put((Object)name, weight);
            weight += step;
        }
        weight = 0.0f;
        for (Binding binding : this.myBindings) {
            String name = binding.getAccessor().getName();
            if (!weights.containsKey((Object)name)) {
                weights.put((Object)name, weight);
            }
            weight += 1.0f;
        }
        return weights;
    }

    public final void sortBindings(@NotNull TObjectFloatHashMap<? super String> weights) {
        Arrays.sort(this.myBindings, (o1, o2) -> {
            String n1 = o1.getAccessor().getName();
            String n2 = o2.getAccessor().getName();
            float w1 = weights.get((Object)n1);
            float w2 = weights.get((Object)n2);
            return (int)(w1 - w2);
        });
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element) {
        this.deserializeInto(result, element, null);
    }

    public final void deserializeInto(@NotNull Object result, @NotNull Element element, @Nullable Set<? super String> accessorNameTracker) {
        block0: for (org.jdom.Attribute attribute : element.getAttributes()) {
            if (!StringUtil.isEmpty(attribute.getNamespaceURI())) continue;
            for (Binding binding : this.myBindings) {
                if (!(binding instanceof AttributeBinding) || !((AttributeBinding)binding).myName.equals(attribute.getName())) continue;
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((AttributeBinding)binding).set(result, attribute.getValue());
                continue block0;
            }
        }
        MultiMap<Binding, Element> data = null;
        block2: for (Content content : element.getContent()) {
            if (content instanceof Comment) continue;
            for (Binding binding : this.myBindings) {
                if (content instanceof org.jdom.Text) {
                    if (!(binding instanceof TextBinding)) continue;
                    ((TextBinding)binding).set(result, content.getValue());
                    continue;
                }
                Element child = (Element)content;
                if (!binding.isBoundTo(child)) continue;
                if (binding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)binding)).isMulti()) {
                    if (data == null) {
                        data = MultiMap.createLinked();
                    }
                    data.putValue(binding, child);
                    continue block2;
                }
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                binding.deserializeUnsafe(result, child);
                continue block2;
            }
        }
        for (Binding binding : this.myBindings) {
            if (!(binding instanceof AccessorBindingWrapper) || !((AccessorBindingWrapper)binding).isFlat()) continue;
            ((AccessorBindingWrapper)binding).deserialize(result, element);
        }
        if (data != null) {
            for (Binding binding : data.keySet()) {
                if (accessorNameTracker != null) {
                    accessorNameTracker.add(binding.getAccessor().getName());
                }
                ((MultiNodeBinding)((Object)binding)).deserializeList(result, (List)data.get(binding));
            }
        }
    }

    @Override
    public final boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myTagName);
    }

    @NotNull
    private static String getTagName(@NotNull Class<?> aClass) {
        int lastIndexOf;
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            String name = BeanBinding.getTagNameFromAnnotation(c);
            if (name == null) continue;
            return name;
        }
        String name = aClass.getSimpleName();
        if (name.isEmpty()) {
            name = aClass.getSuperclass().getSimpleName();
        }
        if ((lastIndexOf = name.lastIndexOf(36)) > 0 && name.length() > lastIndexOf + 1) {
            return name.substring(lastIndexOf + 1);
        }
        return name;
    }

    @Nullable
    private static String getTagNameFromAnnotation(@NotNull Class<?> aClass) {
        Tag tag = aClass.getAnnotation(Tag.class);
        return tag != null && !tag.value().isEmpty() ? tag.value() : null;
    }

    @NotNull
    public static List<MutableAccessor> getAccessors(@NotNull Class<?> aClass) {
        List<MutableAccessor> accessors = ourAccessorCache.get(aClass);
        if (accessors != null) {
            return accessors;
        }
        accessors = new ArrayList<MutableAccessor>();
        Map<Object, Object> nameToAccessors = aClass == Rectangle.class ? Collections.emptyMap() : BeanBinding.collectPropertyAccessors(aClass, accessors);
        int propertyAccessorCount = accessors.size();
        BeanBinding.collectFieldAccessors(aClass, accessors);
        block0: for (int j = propertyAccessorCount; j < accessors.size(); ++j) {
            String name = accessors.get(j).getName();
            if (!nameToAccessors.containsKey(name)) continue;
            for (int i = 0; i < propertyAccessorCount; ++i) {
                if (!accessors.get(i).getName().equals(name)) continue;
                accessors.remove(i);
                --propertyAccessorCount;
                --j;
                continue block0;
            }
        }
        if (accessors.isEmpty() && !BeanBinding.isAssertBindings(aClass)) {
            LOG.warn("no accessors for " + aClass);
        }
        ourAccessorCache.put(aClass, accessors);
        return accessors;
    }

    private static boolean isAssertBindings(@NotNull Class<?> aClass) {
        do {
            Property property;
            if ((property = aClass.getAnnotation(Property.class)) == null || property.assertIfNoBindings()) continue;
            return true;
        } while ((aClass = aClass.getSuperclass()) != null);
        return false;
    }

    @NotNull
    private static Map<String, Couple<Method>> collectPropertyAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors) {
        TreeMap<String, Couple<Method>> candidates = new TreeMap<String, Couple<Method>>();
        for (Method method : aClass.getMethods()) {
            NameAndIsSetter propertyData;
            if (!Modifier.isPublic(method.getModifiers()) || (propertyData = BeanBinding.getPropertyData(method.getName())) == null || propertyData.name.equals("class") || method.getParameterTypes().length != (propertyData.isSetter ? 1 : 0)) continue;
            Couple<Object> candidate = (Couple)candidates.get(propertyData.name);
            if (candidate == null) {
                candidate = Couple.getEmpty();
            }
            if ((propertyData.isSetter ? (Method)candidate.second : (Method)candidate.first) != null) continue;
            candidate = Couple.of(propertyData.isSetter ? (Method)candidate.first : method, propertyData.isSetter ? method : (Method)candidate.second);
            candidates.put(propertyData.name, candidate);
        }
        Iterator iterator = candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry candidate = iterator.next();
            Couple methods = (Couple)candidate.getValue();
            Method getter = (Method)methods.first;
            Method setter = (Method)methods.second;
            if (BeanBinding.isAcceptableProperty(getter, setter)) {
                accessors.add(new PropertyAccessor((String)candidate.getKey(), getter.getReturnType(), getter, setter));
                continue;
            }
            iterator.remove();
        }
        return candidates;
    }

    private static boolean isAcceptableProperty(@Nullable Method getter, @Nullable Method setter) {
        if (getter == null || getter.getAnnotation(Transient.class) != null) {
            return false;
        }
        if (setter == null) {
            return (Collection.class.isAssignableFrom(getter.getReturnType()) || Map.class.isAssignableFrom(getter.getReturnType())) && BeanBinding.hasStoreAnnotations(getter);
        }
        return setter.getAnnotation(Transient.class) == null && getter.getReturnType().equals(setter.getParameterTypes()[0]);
    }

    private static boolean hasStoreAnnotations(@NotNull AccessibleObject object) {
        return object.getAnnotation(OptionTag.class) != null || object.getAnnotation(Tag.class) != null || object.getAnnotation(Attribute.class) != null || object.getAnnotation(Property.class) != null || object.getAnnotation(Text.class) != null || object.getAnnotation(CollectionBean.class) != null || object.getAnnotation(MapAnnotation.class) != null || object.getAnnotation(XMap.class) != null || object.getAnnotation(XCollection.class) != null || object.getAnnotation(AbstractCollection.class) != null;
    }

    private static void collectFieldAccessors(@NotNull Class<?> aClass, @NotNull List<? super MutableAccessor> accessors) {
        Class<?> currentClass = aClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                Class<?> fieldType;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !BeanBinding.hasStoreAnnotations(field) && (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) && !Collection.class.isAssignableFrom(fieldType = field.getType()) && !Map.class.isAssignableFrom(fieldType) || field.getAnnotation(Transient.class) != null)) continue;
                accessors.add(new FieldAccessor(field));
            }
        } while ((currentClass = currentClass.getSuperclass()) != null && currentClass.getAnnotation(Transient.class) == null);
    }

    @Nullable
    private static NameAndIsSetter getPropertyData(@NotNull String methodName) {
        String part = "";
        boolean isSetter = false;
        if (methodName.startsWith("get")) {
            part = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            part = methodName.substring(2);
        } else if (methodName.startsWith("set")) {
            part = methodName.substring(3);
            isSetter = true;
        }
        if (part.isEmpty()) {
            return null;
        }
        int suffixIndex = part.indexOf(36);
        if (suffixIndex > 0) {
            if (part.endsWith("$annotations")) {
                return null;
            }
            part = part.substring(0, suffixIndex);
        }
        return new NameAndIsSetter(Introspector.decapitalize(part), isSetter);
    }

    public String toString() {
        return "BeanBinding[" + this.myBeanClass.getName() + ", tagName=" + this.myTagName + "]";
    }

    @NotNull
    private static Binding createBinding(@NotNull MutableAccessor accessor, @NotNull Serializer serializer, @NotNull Property.Style propertyStyle) {
        XMap xMap;
        Attribute attribute = accessor.getAnnotation(Attribute.class);
        if (attribute != null) {
            return new AttributeBinding(accessor, attribute);
        }
        Text text = accessor.getAnnotation(Text.class);
        if (text != null) {
            return new TextBinding(accessor);
        }
        OptionTag optionTag = accessor.getAnnotation(OptionTag.class);
        if (optionTag != null && optionTag.converter() != Converter.class) {
            return new OptionTagBinding(accessor, optionTag);
        }
        Binding binding = serializer.getBinding(accessor);
        if (binding instanceof JDOMElementBinding) {
            return binding;
        }
        Tag tag = accessor.getAnnotation(Tag.class);
        if (tag != null) {
            return new TagBinding(accessor, tag);
        }
        if (binding instanceof CompactCollectionBinding) {
            return new AccessorBindingWrapper(accessor, binding, false, Property.Style.OPTION_TAG);
        }
        boolean surroundWithTag = true;
        boolean inline = false;
        Property property = accessor.getAnnotation(Property.class);
        if (property != null) {
            surroundWithTag = property.surroundWithTag();
            inline = property.flat();
        }
        if (!surroundWithTag || inline) {
            if (inline && !(binding instanceof BeanBinding)) {
                throw new XmlSerializationException("inline supported only for BeanBinding: " + accessor);
            }
            if (binding == null || binding instanceof TextBinding) {
                throw new XmlSerializationException("Text-serializable properties can't be serialized without surrounding tags: " + accessor);
            }
            return new AccessorBindingWrapper(accessor, binding, inline, property.style());
        }
        XCollection xCollection = accessor.getAnnotation(XCollection.class);
        if (!(xCollection == null || xCollection.propertyElementName().isEmpty() && xCollection.style() != XCollection.Style.v2)) {
            return new TagBinding(accessor, xCollection.propertyElementName());
        }
        if (optionTag == null && (xMap = accessor.getAnnotation(XMap.class)) != null) {
            return new TagBinding(accessor, xMap.propertyElementName());
        }
        if (propertyStyle == Property.Style.ATTRIBUTE) {
            return new AttributeBinding(accessor, null);
        }
        return new OptionTagBinding(accessor, optionTag);
    }

    private static class NameAndIsSetter {
        final String name;
        final boolean isSetter;

        private NameAndIsSetter(String name, boolean isSetter) {
            this.name = name;
            this.isSetter = isSetter;
        }
    }
}

