/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.SmartList;
import com.intellij.util.xmlb.AbstractCollectionBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionBinding
extends AbstractCollectionBinding {
    CollectionBinding(@NotNull ParameterizedType type, @Nullable MutableAccessor accessor) {
        super(XmlSerializerImpl.typeToClass(type.getActualTypeArguments()[0]), accessor);
    }

    private static boolean isMutableCollection(@Nullable Object object) {
        if (object == Collections.emptyList() || object == Collections.emptySet()) {
            return false;
        }
        if (object instanceof Collection) {
            String simpleName = object.getClass().getSimpleName();
            return !simpleName.equals("EmptyList") && !simpleName.startsWith("Unmodifiable") && !simpleName.equals("EmptySet");
        }
        return false;
    }

    @Override
    @NotNull
    protected Object doDeserializeList(@Nullable Object context, @NotNull List<? extends Element> elements) {
        AbstractCollection result;
        boolean isContextMutable = CollectionBinding.isMutableCollection(context);
        if (isContextMutable) {
            result = (AbstractCollection)context;
            result.clear();
        } else {
            result = context instanceof Set ? new HashSet() : new SmartList();
        }
        for (Element element : elements) {
            result.add(this.deserializeItem(element, context));
        }
        return result;
    }

    @Override
    @NotNull
    Collection<Object> getIterable(@NotNull Object o) {
        if (this.isSortOrderedSet() && o instanceof LinkedHashSet) {
            return (Collection)o;
        }
        return o instanceof Set ? new TreeSet((Set)o) : (Collection)o;
    }

    @Override
    @NotNull
    protected String getCollectionTagName(@Nullable Object target) {
        if (target instanceof Set) {
            return "set";
        }
        if (target instanceof List) {
            return "list";
        }
        return "collection";
    }
}

