/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private final String myTagName;

    JDOMElementBinding(@NotNull MutableAccessor accessor) {
        super(accessor);
        Tag tag = this.myAccessor.getAnnotation(Tag.class);
        String tagName = tag == null ? null : tag.value();
        this.myTagName = StringUtil.isEmpty(tagName) ? this.myAccessor.getName() : tagName;
    }

    @Override
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        if (value instanceof Element) {
            Element targetElement = ((Element)value).clone();
            assert (targetElement != null);
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                result.add(element.clone().setName(this.myTagName));
            }
            return result;
        }
        throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<? extends Element> elements) {
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.set(context, elements.toArray(new Element[0]));
        } else {
            this.myAccessor.set(context, elements.get(0));
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        this.myAccessor.set(context, element);
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myTagName);
    }
}

