/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        @NotNull
        public URL resolvePath(@NotNull String relativePath, @Nullable URL base) throws MalformedURLException {
            return base == null ? new URL(relativePath) : new URL(base, relativePath);
        }
    };
    @NonNls
    private static final String HTTP_WWW_W3_ORG_2001_XINCLUDE = "http://www.w3.org/2001/XInclude";
    @NonNls
    private static final String XI = "xi";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String HREF = "href";
    @NonNls
    private static final String BASE = "base";
    @NonNls
    private static final String PARSE = "parse";
    @NonNls
    private static final String XML = "xml";
    @NonNls
    private static final String XPOINTER = "xpointer";
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace((String)"xi", (String)"http://www.w3.org/2001/XInclude");
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;
    @NonNls
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");

    private JDOMXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    @NotNull
    public static Document resolve(Document original, String base) throws XIncludeException, MalformedURLException {
        return JDOMXIncluder.resolve(original, base, false);
    }

    @NotNull
    public static Document resolve(Document original, String base, boolean ignoreMissing) throws XIncludeException, MalformedURLException {
        return JDOMXIncluder.resolve(original, base, ignoreMissing, DEFAULT_PATH_RESOLVER);
    }

    @NotNull
    public static Document resolve(Document original, String base, boolean ignoreMissing, PathResolver pathResolver) throws XIncludeException, MalformedURLException {
        return new JDOMXIncluder(ignoreMissing, pathResolver).doResolve(original, new URL(base));
    }

    @NotNull
    public static List<Content> resolve(@NotNull Element original, String base, boolean ignoreMissing, PathResolver pathResolver) throws XIncludeException, MalformedURLException {
        return new JDOMXIncluder(ignoreMissing, pathResolver).doResolve(original, new URL(base));
    }

    public static void resolveNonXIncludeElement(@NotNull Element original, @Nullable URL base, boolean ignoreMissing, @NotNull PathResolver pathResolver) throws XIncludeException, MalformedURLException {
        LOG.assertTrue(!JDOMXIncluder.isIncludeElement(original));
        Stack<URL> bases = new Stack<URL>();
        if (base != null) {
            bases.push(base);
        }
        new InplaceJdomXIncluder(ignoreMissing, pathResolver).resolveNonXIncludeElement(original, bases);
    }

    @NotNull
    public static List<Content> resolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        return new JDOMXIncluder(false, DEFAULT_PATH_RESOLVER).doResolve(original, base);
    }

    private Document doResolve(Document original, URL base) throws MalformedURLException {
        if (original == null) {
            throw new NullPointerException("Document must not be null");
        }
        Document result = original.clone();
        Element root = result.getRootElement();
        List<Content> resolved = this.doResolve(root, base);
        Element newRoot = null;
        for (Content o : resolved) {
            if (o instanceof Element) {
                if (newRoot != null) {
                    throw new XIncludeException("Tried to include multiple roots");
                }
                newRoot = (Element)o;
                continue;
            }
            if (o instanceof Comment || o instanceof ProcessingInstruction) continue;
            if (o instanceof Text) {
                throw new XIncludeException("Tried to include text node outside of root element");
            }
            if (o instanceof EntityRef) {
                throw new XIncludeException("Tried to include a general entity reference outside of root element");
            }
            throw new XIncludeException("Unexpected type " + o.getClass());
        }
        if (newRoot == null) {
            throw new XIncludeException("No root element");
        }
        List newContent = result.getContent();
        Iterator<Content> iterator = resolved.iterator();
        int rootPosition = newContent.indexOf(result.getRootElement());
        while (iterator.hasNext()) {
            Content o = iterator.next();
            if (o instanceof Comment || o instanceof ProcessingInstruction) {
                newContent.add(rootPosition, o);
                ++rootPosition;
                continue;
            }
            if (!(o instanceof Element)) continue;
            break;
        }
        result.setRootElement(newRoot);
        int addPosition = rootPosition + 1;
        while (iterator.hasNext()) {
            Content o = iterator.next();
            if (!(o instanceof Comment) && !(o instanceof ProcessingInstruction)) continue;
            newContent.add(addPosition, o);
            ++addPosition;
        }
        return result;
    }

    @NotNull
    private List<Content> doResolve(@NotNull Element original, URL base) throws XIncludeException, MalformedURLException {
        Stack<URL> bases = new Stack<URL>();
        if (base != null) {
            bases.push(base);
        }
        return this.resolve(original, bases);
    }

    protected static boolean isIncludeElement(Element element) {
        return element.getName().equals(INCLUDE) && element.getNamespace().equals((Object)XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Content> resolve(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        if (JDOMXIncluder.isIncludeElement(original)) {
            return this.resolveXIncludeElement(original, bases);
        }
        Element resolvedElement = this.resolveNonXIncludeElement(original, bases);
        return Collections.singletonList(resolvedElement);
    }

    @NotNull
    protected List<Content> resolveXIncludeElement(@NotNull Element element, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        URL base = null;
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        String href = element.getAttributeValue(HREF);
        assert (href != null) : "Missing href attribute";
        String baseAttribute = element.getAttributeValue(BASE, Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = new URL(baseAttribute);
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        String parseAttribute = element.getAttributeValue(PARSE);
        if (parseAttribute != null) {
            LOG.assertTrue(parseAttribute.equals(XML), parseAttribute + " is not a legal value for the parse attribute");
        }
        assert (!bases.contains(remote)) : "Circular XInclude Reference to " + remote.toExternalForm();
        Element fallbackElement = element.getChild("fallback", element.getNamespace());
        List<Content> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
        if (!remoteParsed.isEmpty()) {
            remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Content o = remoteParsed.get(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            List<Content> nodes = this.resolve(e, bases);
            remoteParsed.addAll(i, nodes);
            remoteParsed.remove(i += nodes.size());
            --i;
            e.detach();
        }
        for (Content content : remoteParsed) {
            content.detach();
        }
        return remoteParsed;
    }

    @NotNull
    private static List<Content> extractNeededChildren(@NotNull Element element, @NotNull List<Content> remoteElements) {
        String xpointer = element.getAttributeValue(XPOINTER);
        if (xpointer == null) {
            return remoteElements;
        }
        Matcher matcher = XPOINTER_PATTERN.matcher(xpointer);
        boolean b = matcher.matches();
        assert (b) : "Unsupported XPointer: " + xpointer;
        String pointer = matcher.group(1);
        matcher = CHILDREN_PATTERN.matcher(pointer);
        b = matcher.matches();
        assert (b) : "Unsupported pointer: " + pointer;
        String rootTagName = matcher.group(1);
        assert (remoteElements.size() == 1);
        assert (remoteElements.get(0) instanceof Element);
        Element e = (Element)remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            return Collections.emptyList();
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
        }
        assert (e != null);
        return new ArrayList<Content>(e.getContent());
    }

    @NotNull
    private List<Content> parseRemote(@NotNull Stack<URL> bases, @NotNull URL remote, @Nullable Element fallbackElement) {
        try {
            bases.push(remote);
            Element root = JDOMUtil.loadResource(remote);
            List<Content> list = this.resolve(root, bases);
            bases.pop();
            return list;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                return Collections.emptyList();
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                return Collections.emptyList();
            }
            throw new XIncludeException(e);
        }
    }

    @NotNull
    protected Element resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
        Element result = new Element(original.getName(), original.getNamespace());
        if (original.hasAttributes()) {
            for (Attribute a : original.getAttributes()) {
                result.setAttribute(a.clone());
            }
        }
        for (Content o : original.getContent()) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (JDOMXIncluder.isIncludeElement(element)) {
                    result.addContent(this.resolveXIncludeElement(element, bases));
                    continue;
                }
                result.addContent(this.resolveNonXIncludeElement(element, bases));
                continue;
            }
            result.addContent(o.clone());
        }
        return result;
    }

    public static interface PathResolver {
        @NotNull
        public URL resolvePath(@NotNull String var1, @Nullable URL var2) throws MalformedURLException;
    }

    private static final class InplaceJdomXIncluder
    extends JDOMXIncluder {
        private InplaceJdomXIncluder(boolean ignoreMissing, @NotNull PathResolver pathResolver) {
            super(ignoreMissing, pathResolver);
        }

        @Override
        @NotNull
        protected Element resolveNonXIncludeElement(@NotNull Element original, @NotNull Stack<URL> bases) throws XIncludeException, MalformedURLException {
            List contentList = original.getContent();
            for (int i = contentList.size() - 1; i >= 0; --i) {
                Content content = (Content)contentList.get(i);
                if (!(content instanceof Element)) continue;
                Element element = (Element)content;
                if (InplaceJdomXIncluder.isIncludeElement(element)) {
                    original.setContent(i, this.resolveXIncludeElement(element, bases));
                    continue;
                }
                this.resolveNonXIncludeElement(element, bases);
            }
            return original;
        }
    }
}

