/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapBinding
extends Binding
implements MultiNodeBinding {
    private static final Comparator<Object> KEY_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        return 0;
    };
    private final MapAnnotation oldAnnotation;
    private final XMap annotation;
    @NotNull
    private final Class<? extends Map> mapClass;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;

    MapBinding(@Nullable MutableAccessor accessor, @NotNull Class<? extends Map> mapClass) {
        super(accessor);
        this.oldAnnotation = accessor == null ? null : accessor.getAnnotation(MapAnnotation.class);
        this.annotation = accessor == null ? null : accessor.getAnnotation(XMap.class);
        this.mapClass = mapClass;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer) {
        ParameterizedType type = (ParameterizedType)originalType;
        Type[] typeArguments = type.getActualTypeArguments();
        this.keyClass = XmlSerializerImpl.typeToClass(typeArguments[0]);
        this.valueClass = XmlSerializerImpl.typeToClass(typeArguments[1]);
        this.keyBinding = serializer.getBinding(this.keyClass, typeArguments[0]);
        this.valueBinding = serializer.getBinding(this.valueClass, typeArguments[1]);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private boolean isSortMap(Map<?, ?> map) {
        if (map instanceof TreeMap || this.annotation != null && map instanceof LinkedHashMap) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.sortBeforeSave();
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        Element serialized;
        Element element = serialized = this.isSurroundWithTag() ? new Element("map") : (Element)context;
        assert (serialized != null);
        Map map = (Map)o;
        Object[] keys = ArrayUtil.toObjectArray(map.keySet());
        if (this.isSortMap(map)) {
            Arrays.sort(keys, KEY_COMPARATOR);
        }
        for (Object k : keys) {
            Element entry = new Element(this.getEntryElementName());
            serialized.addContent(entry);
            this.serializeKeyOrValue(entry, this.getKeyAttributeName(), k, this.keyBinding, filter);
            this.serializeKeyOrValue(entry, this.getValueAttributeName(), map.get(k), this.valueBinding, filter);
        }
        return serialized == context ? null : serialized;
    }

    protected boolean isSurroundWithTag() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundWithTag();
    }

    @NotNull
    String getEntryElementName() {
        if (this.annotation != null) {
            return this.annotation.entryTagName();
        }
        return this.oldAnnotation == null ? "entry" : this.oldAnnotation.entryTagName();
    }

    private String getKeyAttributeName() {
        if (this.annotation != null) {
            return this.annotation.keyAttributeName();
        }
        return this.oldAnnotation == null ? "key" : this.oldAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        if (this.annotation != null) {
            return this.annotation.valueAttributeName();
        }
        return this.oldAnnotation == null ? "value" : this.oldAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<? extends Element> elements) {
        List childNodes;
        if (this.isSurroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get(0).getChildren();
        } else {
            childNodes = elements;
        }
        return this.deserialize(context, childNodes);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull Element element) {
        return null;
    }

    @Nullable
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        if (this.isSurroundWithTag()) {
            return this.deserialize(context, element.getChildren());
        }
        return this.deserialize(context, Collections.singletonList(element));
    }

    private static boolean isMutableMap(@NotNull Map object) {
        if (object == Collections.emptyMap()) {
            return false;
        }
        String simpleName = object.getClass().getSimpleName();
        return !simpleName.equals("EmptyMap") && !simpleName.equals("UnmodifiableMap");
    }

    @Nullable
    private Map deserialize(@Nullable Object context, @NotNull List<? extends Element> childNodes) {
        Map map;
        Map map2 = map = this.myAccessor == null ? null : (Map)context;
        if (map != null) {
            if (MapBinding.isMutableMap(map)) {
                map.clear();
            } else {
                map = null;
            }
        }
        for (Element element : childNodes) {
            if (!element.getName().equals(this.getEntryElementName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + element);
                continue;
            }
            if (map == null) {
                if (this.mapClass == Map.class) {
                    map = new THashMap();
                } else {
                    try {
                        map = ReflectionUtil.newInstance(this.mapClass);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                        map = new THashMap();
                    }
                }
            }
            map.put(this.deserializeKeyOrValue(element, this.getKeyAttributeName(), context, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(element, this.getValueAttributeName(), context, this.valueBinding, this.valueClass));
        }
        return map;
    }

    private void serializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, @Nullable Object value, @Nullable Binding binding, @Nullable SerializationFilter filter) {
        if (value == null) {
            return;
        }
        if (binding == null) {
            entry.setAttribute(attributeName, JDOMUtil.removeControlChars(XmlSerializerImpl.convertToString(value)));
        } else {
            Object serialized = binding.serialize(value, entry, filter);
            if (serialized != null) {
                if (this.isSurroundKey()) {
                    Element container = new Element(attributeName);
                    container.addContent((Content)serialized);
                    entry.addContent(container);
                } else {
                    entry.addContent((Content)serialized);
                }
            }
        }
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        Attribute attribute = entry.getAttribute(attributeName);
        if (attribute != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (!this.isSurroundKey()) {
            assert (binding != null);
            for (Element element : entry.getChildren()) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserializeUnsafe(context, element);
            }
        } else {
            List children;
            Element entryChild = entry.getChild(attributeName);
            List list = children = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, null, children);
        }
        return null;
    }

    private boolean isSurroundKey() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundKeyWithTag();
    }

    boolean isBoundToWithoutProperty(@NotNull Element element) {
        String elementName = element.getName();
        if (this.annotation != null) {
            return elementName.equals(this.annotation.entryTagName());
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return elementName.equals(this.oldAnnotation.entryTagName());
        }
        return elementName.equals("map");
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return this.oldAnnotation.entryTagName().equals(element.getName());
        }
        if (this.annotation != null) {
            return this.annotation.propertyElementName().equals(element.getName());
        }
        return element.getName().equals("map");
    }
}

