/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyAccessor
implements MutableAccessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, @NotNull Method readMethod, @Nullable Method writeMethod) {
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            if (this.myWriteMethod != null) {
                this.myWriteMethod.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @NotNull
    public String getGetterName() {
        return this.myReadMethod.getName();
    }

    @Override
    public Object read(@NotNull Object o) {
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            ExceptionUtil.rethrowUnchecked(exception);
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        try {
            this.myWriteMethod.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            T[] constants;
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && this.myGenericType instanceof Class && ((Class)this.myGenericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.myGenericType).getEnumConstants()).length > 0) {
                try {
                    Binding.LOG.warn("Cannot set enum value, will be set to first enum value", e);
                    this.myWriteMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException e1) {
                    throw new XmlSerializationException(e);
                }
                catch (InvocationTargetException e1) {
                    throw new XmlSerializationException(cause);
                }
            }
            throw new XmlSerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        this.set(host, value);
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        this.set(host, value);
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        this.set(host, value);
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        this.set(host, value);
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        this.set(host, value);
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation = this.myReadMethod.getAnnotation(annotationClass);
        if (annotation == null && this.myWriteMethod != null) {
            annotation = this.myWriteMethod.getAnnotation(annotationClass);
        }
        return annotation;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return this.myWriteMethod == null;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

