/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    TagBinding(@NotNull MutableAccessor accessor, @NotNull Tag tagAnnotation) {
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = tagAnnotation.textIfEmpty();
    }

    TagBinding(@NotNull MutableAccessor accessor, @NotNull String suggestedName) {
        super(accessor, suggestedName, null);
        this.myTextIfEmpty = "";
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        Element serialized = new Element(this.myName);
        if (this.myBinding == null) {
            serialized.addContent((Content)new Text(XmlSerializerImpl.convertToString(value)));
        } else {
            Object node = this.myBinding.serialize(value, serialized, filter);
            if (node != null && node != serialized) {
                TagBinding.addContent(serialized, node);
            }
        }
        return serialized;
    }

    @Override
    @Nullable
    public Object deserializeList(@NotNull Object context, @NotNull List<? extends Element> elements) {
        ArrayList children;
        if (elements.size() == 1) {
            children = elements.get(0).getChildren();
        } else {
            String name = elements.get(0).getName();
            children = new ArrayList();
            for (Element element : elements) {
                assert (element.getName().equals(name));
                children.addAll(element.getChildren());
            }
        }
        this.deserialize(context, children);
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    @NotNull
    public Object deserialize(@NotNull Object context, @NotNull Element element) {
        if (this.myBinding == null) {
            String value = XmlSerializerImpl.getTextValue(element, this.myTextIfEmpty);
            XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize(context, element.getChildren());
        }
        return context;
    }

    private void deserialize(@NotNull Object context, @NotNull List<? extends Element> children) {
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(context, children.get(0));
        } else {
            this.myAccessor.set(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children));
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        return element.getName().equals(this.myName);
    }
}

