/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.io.IOException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){

        @Override
        public boolean accepts(@NotNull Accessor accessor, @NotNull Object bean) {
            return true;
        }
    };

    private XmlSerializer() {
    }

    public static Element serialize(@NotNull Object object) throws XmlSerializationException {
        return XmlSerializer.serialize(object, TRUE_FILTER);
    }

    @NotNull
    public static Element serialize(@NotNull Object object, @Nullable SerializationFilter filter) throws XmlSerializationException {
        return XmlSerializerImpl.serialize(object, filter == null ? TRUE_FILTER : filter);
    }

    @Nullable
    public static Element serializeIfNotDefault(@NotNull Object object, @Nullable SerializationFilter filter) {
        SerializationFilter filter1 = filter == null ? TRUE_FILTER : filter;
        Class<?> aClass = object.getClass();
        return (Element)XmlSerializerImpl.serializer.getClassBinding(aClass).serialize(object, null, filter1);
    }

    @NotNull
    public static <T> T deserialize(Document document, Class<T> aClass) throws XmlSerializationException {
        return XmlSerializer.deserialize(document.getRootElement(), aClass);
    }

    @NotNull
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass) throws XmlSerializationException {
        try {
            NotNullDeserializeBinding binding = (NotNullDeserializeBinding)XmlSerializerImpl.serializer.getClassBinding(aClass);
            return (T)binding.deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass.getName(), e);
        }
    }

    @NotNull
    public static <T> T deserialize(@NotNull URL url, Class<T> aClass) throws XmlSerializationException {
        try {
            Document document = JDOMUtil.loadDocument(url);
            document = JDOMXIncluder.resolve(document, url.toExternalForm());
            return XmlSerializer.deserialize(document.getRootElement(), aClass);
        }
        catch (IOException | JDOMException e) {
            throw new XmlSerializationException(e);
        }
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        try {
            XmlSerializer.getBeanBinding(bean).deserializeInto(bean, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }

    @ApiStatus.Experimental
    @NotNull
    public static BeanBinding getBeanBinding(@NotNull Object bean) {
        return (BeanBinding)XmlSerializerImpl.serializer.getClassBinding(bean.getClass());
    }

    public static void serializeInto(Object bean, Element element) {
        XmlSerializer.serializeInto(bean, element, null);
    }

    public static void serializeInto(@NotNull Object bean, @NotNull Element element, @Nullable SerializationFilter filter) {
        if (filter == null) {
            filter = TRUE_FILTER;
        }
        try {
            XmlSerializer.getBeanBinding(bean).serializeInto(bean, element, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

