/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.AttributeType;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.Element;
import org.jdom.ImmutableAttribute;
import org.jdom.ImmutableSameTypeAttributeList;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImmutableElement
extends Element {
    private static final List<Attribute> EMPTY_LIST = new ImmutableSameTypeAttributeList(ArrayUtil.EMPTY_STRING_ARRAY, null, Namespace.NO_NAMESPACE);
    private final Content[] myContent;
    private static final Content[] EMPTY_CONTENT = new Content[0];
    private final List<Attribute> myAttributes;

    ImmutableElement(@NotNull Element origin, @NotNull JDOMInterner interner) {
        this.content = null;
        this.name = interner.internString(origin.getName());
        this.myAttributes = ImmutableElement.internAttributes(origin, interner);
        List origContent = origin.getContent();
        if (origContent.isEmpty()) {
            this.myContent = EMPTY_CONTENT;
        } else {
            Content[] newContent = new Content[origContent.size()];
            int index = 0;
            for (Content o : origContent) {
                if (o instanceof Element) {
                    Element newElement = interner.internElement((Element)o);
                    newContent[index++] = newElement;
                    continue;
                }
                if (o instanceof Text) {
                    Text newText = interner.internText((Text)o);
                    newContent[index++] = newText;
                    continue;
                }
                if (o instanceof Comment) continue;
                throw new RuntimeException(o.toString());
            }
            this.myContent = index == newContent.length ? newContent : Arrays.copyOf(newContent, index);
        }
        this.namespace = origin.getNamespace();
        for (Namespace addns : origin.getAdditionalNamespaces()) {
            super.addNamespaceDeclaration(addns);
        }
    }

    @NotNull
    private static List<Attribute> internAttributes(@NotNull Element origin, @NotNull JDOMInterner interner) {
        List<Attribute> originAttributes = JDOMUtil.getAttributes(origin);
        if (originAttributes.isEmpty()) {
            return EMPTY_LIST;
        }
        AttributeType type = null;
        String[] nameValues = new String[originAttributes.size() * 2];
        Namespace namespace = null;
        for (int i = 0; i < originAttributes.size(); ++i) {
            Attribute origAttribute = originAttributes.get(i);
            if (type == null) {
                type = origAttribute.getAttributeType();
                namespace = origAttribute.getNamespace();
            } else if (type != origAttribute.getAttributeType() || !origAttribute.getNamespace().equals((Object)namespace)) {
                type = null;
                break;
            }
            String name = interner.internString(origAttribute.getName());
            String value = interner.internString(origAttribute.getValue());
            nameValues[i * 2] = name;
            nameValues[i * 2 + 1] = value;
        }
        if (type == null) {
            return Collections.unmodifiableList(ContainerUtil.map(originAttributes, attribute -> new ImmutableAttribute(interner.internString(attribute.getName()), interner.internString(attribute.getValue()), attribute.getAttributeType(), attribute.getNamespace())));
        }
        return new ImmutableSameTypeAttributeList(nameValues, type, namespace);
    }

    public int getContentSize() {
        return this.myContent.length;
    }

    @NotNull
    public List<Content> getContent() {
        return Arrays.asList(this.myContent);
    }

    public <T extends Content> List<T> getContent(Filter<T> filter) {
        return ContainerUtil.filter(this.myContent, arg_0 -> filter.matches(arg_0));
    }

    public Content getContent(int index) {
        return this.myContent[index];
    }

    public Iterator<Content> getDescendants() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public <T extends Content> Iterator<T> getDescendants(Filter<T> filter) {
        throw ImmutableElement.immutableError((Object)this);
    }

    @NotNull
    public List<Element> getChildren() {
        return this.getContent((Filter)new ElementFilter());
    }

    @NotNull
    public List<Element> getChildren(String name, Namespace ns) {
        return this.getContent((Filter)new ElementFilter(name, ns));
    }

    public Element getChild(String name, Namespace ns) {
        List<Element> children = this.getChildren(name, ns);
        return children.isEmpty() ? null : children.get(0);
    }

    public String getText() {
        if (this.myContent.length == 0) {
            return "";
        }
        if (this.myContent.length == 1) {
            Content obj = this.myContent[0];
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            return "";
        }
        StringBuilder textContent = new StringBuilder();
        boolean hasText = false;
        for (Content content : this.myContent) {
            if (!(content instanceof Text)) continue;
            textContent.append(((Text)content).getText());
            hasText = true;
        }
        return hasText ? textContent.toString() : "";
    }

    public int indexOf(Content child) {
        return ArrayUtil.indexOf(this.myContent, child);
    }

    public Namespace getNamespace(String prefix) {
        Namespace ns = super.getNamespace(prefix);
        if (ns == null) {
            for (Attribute a : this.myAttributes) {
                if (!prefix.equals(a.getNamespacePrefix())) continue;
                return a.getNamespace();
            }
        }
        return ns;
    }

    public boolean hasAttributes() {
        return !this.myAttributes.isEmpty();
    }

    public List<Attribute> getAttributes() {
        return this.myAttributes;
    }

    public int getAttributesSize() {
        return this.myAttributes.size();
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).get(name, ns);
        }
        String uri = this.namespace.getURI();
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute a = this.myAttributes.get(i);
            String oldURI = a.getNamespaceURI();
            String oldName = a.getName();
            if (!oldURI.equals(uri) || !oldName.equals(name)) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public String getAttributeValue(String attname) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String attname, String def) {
        return this.getAttributeValue(attname, Namespace.NO_NAMESPACE, def);
    }

    public String getAttributeValue(String attname, Namespace ns) {
        return this.getAttributeValue(attname, ns, null);
    }

    public String getAttributeValue(String name, Namespace ns, String def) {
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return ((ImmutableSameTypeAttributeList)this.myAttributes).getValue(name, ns, def);
        }
        Attribute attribute = this.getAttribute(name, ns);
        return attribute == null ? def : attribute.getValue();
    }

    public Element clone() {
        Element element = new Element();
        element.content = new ContentList((Parent)element);
        element.attributes = new AttributeList(element);
        element.name = this.getName();
        element.namespace = this.getNamespace();
        List<Attribute> attributes = this.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                element.attributes.add(attribute.clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList(this.additionalNamespaces);
        }
        List<Content> content = this.getContent();
        for (Content c : content) {
            element.content.add((Object)c.clone());
        }
        return element;
    }

    public Element getParent() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean attributesEqual(Element element) {
        List attrs = element.getAttributes();
        if (this.myAttributes instanceof ImmutableSameTypeAttributeList) {
            return this.myAttributes.equals(attrs);
        }
        if (this.myAttributes.size() != attrs.size()) {
            return false;
        }
        for (int i = 0; i < this.myAttributes.size(); ++i) {
            Attribute oAttr;
            Attribute attribute = this.myAttributes.get(i);
            if (ImmutableElement.attributesEqual(attribute, oAttr = (Attribute)attrs.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributesEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && Comparing.equal(a1.getValue(), a2.getValue()) && a1.getAttributeType() == a2.getAttributeType() && a1.getNamespace().equals((Object)a2.getNamespace());
    }

    @NotNull
    static IncorrectOperationException immutableError(Object element) {
        return new IncorrectOperationException("Can't change immutable element: " + element.getClass() + ". To obtain mutable Element call .clone()");
    }

    public Element detach() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setName(String name) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setNamespace(Namespace namespace) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public void removeNamespaceDeclaration(Namespace additionalNamespace) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setText(String text) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public List<Content> removeContent() {
        throw ImmutableElement.immutableError((Object)this);
    }

    public <T extends Content> List<T> removeContent(Filter<T> filter) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(int index, Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Parent setContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(String str) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Element child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(int index, Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element addContent(int index, Collection<? extends Content> newContent) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Content removeContent(int index) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setContent(Content child) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttributes(Collection newAttributes) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttributes(List newAttributes) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull String name, @NotNull String value) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull String name, @NotNull String value, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public Element setAttribute(@NotNull Attribute attribute) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(String name) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(String name, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeAttribute(Attribute attribute) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChild(String name) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChild(String name, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChildren(String name) {
        throw ImmutableElement.immutableError((Object)this);
    }

    public boolean removeChildren(String name, Namespace ns) {
        throw ImmutableElement.immutableError((Object)this);
    }

    protected Content setParent(Parent parent) {
        throw ImmutableElement.immutableError((Object)this);
    }
}

