/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.gradle.util.GUtil;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public final class UseDistributionWithSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    public static final Pattern GRADLE_SRC_DISTRIBUTION_PATTERN;
    private static final Logger LOG;
    private static final Key<EditorNotificationPanel> KEY;
    private static final String ALL_ZIP_DISTRIBUTION_URI_SUFFIX = "-all.zip";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        try {
            if ("build.gradle".equals(file.getName()) || "settings.gradle".equals(file.getName())) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                if (module == null) {
                    return null;
                }
                String rootProjectPath = UseDistributionWithSourcesNotificationProvider.getRootProjectPath(module);
                if (rootProjectPath == null) {
                    return null;
                }
                GradleProjectSettings settings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(rootProjectPath);
                if (settings == null || settings.getDistributionType() != DistributionType.DEFAULT_WRAPPED) {
                    return null;
                }
                if (settings.isDisableWrapperSourceDistributionNotification()) {
                    return null;
                }
                if (!UseDistributionWithSourcesNotificationProvider.showUseDistributionWithSourcesTip(rootProjectPath)) {
                    return null;
                }
                EditorNotificationPanel panel = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN);
                panel.setText(GradleBundle.message((String)"gradle.notifications.use.distribution.with.sources", (Object[])new Object[0]));
                panel.createActionLabel(GradleBundle.message((String)"gradle.notifications.hide.tip", (Object[])new Object[0]), () -> {
                    settings.setDisableWrapperSourceDistributionNotification(true);
                    EditorNotifications.getInstance((Project)module.getProject()).updateAllNotifications();
                });
                panel.createActionLabel(GradleBundle.message((String)"gradle.notifications.apply.suggestion", (Object[])new Object[0]), () -> {
                    UseDistributionWithSourcesNotificationProvider.updateDefaultWrapperConfiguration(rootProjectPath);
                    EditorNotifications.getInstance((Project)module.getProject()).updateAllNotifications();
                    ExternalSystemUtil.refreshProject((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)settings.getExternalProjectPath(), (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.START_IN_FOREGROUND_ASYNC);
                });
                return panel;
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException throwable) {
            // empty catch block
        }
        return null;
    }

    private static void updateDefaultWrapperConfiguration(@NotNull String linkedProjectPath) {
        try {
            File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile((String)linkedProjectPath);
            if (wrapperPropertiesFile == null) {
                return;
            }
            WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)linkedProjectPath);
            if (wrapperConfiguration == null) {
                return;
            }
            String currentDistributionUri = wrapperConfiguration.getDistribution().toString();
            if (StringUtil.endsWith((CharSequence)currentDistributionUri, (CharSequence)ALL_ZIP_DISTRIBUTION_URI_SUFFIX)) {
                return;
            }
            String distributionUri = currentDistributionUri.substring(0, currentDistributionUri.lastIndexOf(45)) + ALL_ZIP_DISTRIBUTION_URI_SUFFIX;
            wrapperConfiguration.setDistribution(new URI(distributionUri));
            Properties wrapperProperties = new Properties();
            wrapperProperties.setProperty("distributionUrl", wrapperConfiguration.getDistribution().toString());
            wrapperProperties.setProperty("distributionBase", wrapperConfiguration.getDistributionBase());
            wrapperProperties.setProperty("distributionPath", wrapperConfiguration.getDistributionPath());
            wrapperProperties.setProperty("zipStoreBase", wrapperConfiguration.getZipBase());
            wrapperProperties.setProperty("zipStorePath", wrapperConfiguration.getZipPath());
            GUtil.saveProperties((Properties)wrapperProperties, (File)new File(wrapperPropertiesFile.getPath()));
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(wrapperPropertiesFile));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean showUseDistributionWithSourcesTip(String linkedProjectPath) {
        WrapperConfiguration wrapperConfiguration = GradleUtil.getWrapperConfiguration((String)linkedProjectPath);
        if (wrapperConfiguration == null) {
            return true;
        }
        String distributionUri = wrapperConfiguration.getDistribution().toString();
        try {
            String host = new URI(distributionUri).getHost();
            return host != null && host.endsWith("gradle.org") && !GRADLE_SRC_DISTRIBUTION_PATTERN.matcher(distributionUri).matches();
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Nullable
    private static String getRootProjectPath(@NotNull Module module) {
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
        String externalSystemId = modulePropertyManager.getExternalSystemId();
        if (externalSystemId == null || !GradleConstants.SYSTEM_ID.toString().equals(externalSystemId)) {
            return null;
        }
        String path = modulePropertyManager.getRootProjectPath();
        return StringUtil.isEmpty((String)path) ? null : path;
    }

    static {
        LOG = Logger.getInstance(UseDistributionWithSourcesNotificationProvider.class);
        KEY = Key.create((String)"gradle.notifications.use.distribution.with.sources");
        GRADLE_SRC_DISTRIBUTION_PATTERN = Pattern.compile("https?\\\\?://services\\.gradle\\.org.*-all.zip");
    }
}

