/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.compiler;

import com.google.gson.Gson;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import groovy.lang.GroovyObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.taskdefs.Ant;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

public class GradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;
    private List<String> myGradleClasspath;

    public GradleBuildProcessParametersProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        ArrayList result = ContainerUtil.newArrayList();
        if (!GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty()) {
            this.addGradleClassPath(result);
            GradleBuildProcessParametersProvider.addOtherClassPath(result);
        }
        return result;
    }

    private void addGradleClassPath(@NotNull List<String> classpath) {
        if (this.myGradleClasspath == null) {
            String gradleToolingApiImplDepJarPath;
            this.myGradleClasspath = ContainerUtil.newArrayList();
            String gradleToolingApiJarPath = PathUtil.getJarPathForClass(ProjectConnection.class);
            if (!StringUtil.isEmpty((String)gradleToolingApiJarPath)) {
                this.myGradleClasspath.add(gradleToolingApiJarPath);
            }
            if (!StringUtil.isEmpty((String)(gradleToolingApiImplDepJarPath = PathUtil.getJarPathForClass(Optional.class)))) {
                this.myGradleClasspath.add(gradleToolingApiImplDepJarPath);
            }
        }
        ContainerUtil.addAll(classpath, this.myGradleClasspath);
    }

    private static void addOtherClassPath(@NotNull List<String> classpath) {
        classpath.add(PathUtil.getJarPathForClass(Ant.class));
        classpath.add(PathUtil.getJarPathForClass(GroovyObject.class));
        classpath.add(PathUtil.getJarPathForClass(Gson.class));
        classpath.add(PathUtil.getJarPathForClass(Logger.class));
        classpath.add(PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
    }
}

