/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.ProjectTopics;
import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.project.ProjectTypeService;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ModuleVersion;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleResourceCompilerConfigurationGenerator {
    private static final Logger LOG = Logger.getInstance(GradleResourceCompilerConfigurationGenerator.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, Integer> myModulesConfigurationHash;
    private final ExternalProjectDataCache externalProjectDataCache;

    public GradleResourceCompilerConfigurationGenerator(@NotNull Project project) {
        this.myProject = project;
        this.myModulesConfigurationHash = ContainerUtil.newConcurrentMap();
        this.externalProjectDataCache = ExternalProjectDataCache.getInstance((Project)project);
        assert (this.externalProjectDataCache != null);
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                GradleResourceCompilerConfigurationGenerator.this.myModulesConfigurationHash.remove(module.getName());
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                for (Module module : modules) {
                    this.moduleRemoved(project, module);
                }
            }
        });
    }

    public void generateBuildConfiguration(@NotNull CompileContext context) {
        if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(this.myProject)) {
            return;
        }
        if (!GradleResourceCompilerConfigurationGenerator.hasGradleModules(context)) {
            return;
        }
        BuildManager buildManager = BuildManager.getInstance();
        File projectSystemDir = buildManager.getProjectSystemDirectory(this.myProject);
        if (projectSystemDir == null) {
            return;
        }
        File gradleConfigFile = new File(projectSystemDir, "gradle/configuration.xml");
        Map<String, GradleModuleResourceConfiguration> affectedGradleModuleConfigurations = this.generateAffectedGradleModulesConfiguration(context);
        if (affectedGradleModuleConfigurations.isEmpty()) {
            return;
        }
        boolean configurationUpdateRequired = context.isRebuild() || !gradleConfigFile.exists();
        THashMap affectedConfigurationHash = new THashMap();
        for (Map.Entry<String, GradleModuleResourceConfiguration> entry : affectedGradleModuleConfigurations.entrySet()) {
            Integer moduleLastConfigurationHash = this.myModulesConfigurationHash.get(entry.getKey());
            int moduleCurrentConfigurationHash = entry.getValue().computeConfigurationHash();
            if (moduleLastConfigurationHash == null || moduleLastConfigurationHash != moduleCurrentConfigurationHash) {
                configurationUpdateRequired = true;
            }
            affectedConfigurationHash.put(entry.getKey(), moduleCurrentConfigurationHash);
        }
        GradleProjectConfiguration projectConfig = this.loadLastConfiguration(gradleConfigFile);
        projectConfig.moduleConfigurations.putAll(affectedGradleModuleConfigurations);
        Element element = new Element("gradle-project-configuration");
        XmlSerializer.serializeInto((Object)projectConfig, (Element)element);
        boolean finalConfigurationUpdateRequired = configurationUpdateRequired;
        buildManager.runCommand(() -> this.lambda$generateBuildConfiguration$0(finalConfigurationUpdateRequired, buildManager, gradleConfigFile, element, (Map)affectedConfigurationHash));
    }

    @NotNull
    private GradleProjectConfiguration loadLastConfiguration(@NotNull File gradleConfigFile) {
        GradleProjectConfiguration projectConfig = new GradleProjectConfiguration();
        if (gradleConfigFile.exists()) {
            try {
                XmlSerializer.deserializeInto((Object)projectConfig, (Element)JDOMUtil.load((File)gradleConfigFile));
                Set<String> actualModules = this.myModulesConfigurationHash.keySet();
                Iterator iterator = projectConfig.moduleConfigurations.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry configurationEntry = iterator.next();
                    if (actualModules.contains(configurationEntry.getKey())) continue;
                    iterator.remove();
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        return projectConfig;
    }

    @NotNull
    private Map<String, GradleModuleResourceConfiguration> generateAffectedGradleModulesConfiguration(@NotNull CompileContext context) {
        THashMap affectedGradleModuleConfigurations = ContainerUtil.newTroveMap();
        Map lazyExternalProjectMap = FactoryMap.create(gradleProjectPath1 -> this.externalProjectDataCache.getRootExternalProject(gradleProjectPath1));
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            String gradleProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
            assert (gradleProjectPath != null);
            if (GradleResourceCompilerConfigurationGenerator.shouldBeBuiltByExternalSystem(module)) continue;
            ExternalProject externalRootProject = (ExternalProject)lazyExternalProjectMap.get(gradleProjectPath);
            if (externalRootProject == null) {
                context.addMessage(CompilerMessageCategory.WARNING, String.format("Unable to make the module: %s, related gradle configuration was not found. Please, re-import the Gradle project and try again.", module.getName()), VfsUtilCore.pathToUrl((String)gradleProjectPath), -1, -1);
                continue;
            }
            Map externalSourceSets = this.externalProjectDataCache.findExternalProject(externalRootProject, module);
            if (externalSourceSets.isEmpty()) {
                LOG.debug("Unable to find source sets config for module: " + module.getName());
                continue;
            }
            VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots(true);
            if (sourceRoots.length == 0) continue;
            GradleModuleResourceConfiguration resourceConfig = new GradleModuleResourceConfiguration();
            resourceConfig.id = new ModuleVersion(ExternalSystemApiUtil.getExternalProjectGroup((Module)module), ExternalSystemApiUtil.getExternalProjectId((Module)module), ExternalSystemApiUtil.getExternalProjectVersion((Module)module));
            for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
                GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.resources, (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.SOURCE));
                GradleResourceCompilerConfigurationGenerator.addResources(resourceConfig.testResources, (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), (ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST));
            }
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited()) {
                String outputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrl());
                for (ResourceRootConfiguration resource : resourceConfig.resources) {
                    resource.targetPath = outputPath;
                }
                String testOutputPath = VfsUtilCore.urlToPath((String)compilerModuleExtension.getCompilerOutputUrlForTests());
                for (ResourceRootConfiguration resource : resourceConfig.testResources) {
                    resource.targetPath = testOutputPath;
                }
            }
            affectedGradleModuleConfigurations.put(module.getName(), resourceConfig);
        }
        return affectedGradleModuleConfigurations;
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Project project) {
        ProjectType projectType = ProjectTypeService.getProjectType((Project)project);
        return projectType != null && "Android".equals(projectType.getId());
    }

    private static boolean shouldBeBuiltByExternalSystem(@NotNull Module module) {
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!ArrayUtil.contains((String)facet.getName(), (String[])new String[]{"Android", "Android-Gradle", "Java-Gradle"})) continue;
            return true;
        }
        return false;
    }

    private static boolean hasGradleModules(@NotNull CompileContext context) {
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) continue;
            return true;
        }
        return false;
    }

    private static void addResources(@NotNull List<ResourceRootConfiguration> container, @Nullable ExternalSourceDirectorySet directorySet, @Nullable ExternalSourceDirectorySet sourcesDirectorySet) {
        if (directorySet == null) {
            return;
        }
        for (File file : directorySet.getSrcDirs()) {
            String dir = file.getPath();
            ResourceRootConfiguration rootConfiguration = new ResourceRootConfiguration();
            rootConfiguration.directory = FileUtil.toSystemIndependentName((String)dir);
            String target = directorySet.getOutputDir().getPath();
            rootConfiguration.targetPath = FileUtil.toSystemIndependentName((String)target);
            rootConfiguration.includes.clear();
            for (String include : directorySet.getPatterns().getIncludes()) {
                rootConfiguration.includes.add(include.trim());
            }
            rootConfiguration.excludes.clear();
            for (String exclude : directorySet.getPatterns().getExcludes()) {
                rootConfiguration.excludes.add(exclude.trim());
            }
            if (sourcesDirectorySet != null && sourcesDirectorySet.getSrcDirs().contains(file)) {
                rootConfiguration.excludes.add("**/*.java");
                rootConfiguration.excludes.add("**/*.scala");
                rootConfiguration.excludes.add("**/*.groovy");
                rootConfiguration.excludes.add("**/*.kt");
            }
            rootConfiguration.isFiltered = !directorySet.getFilters().isEmpty();
            rootConfiguration.filters.clear();
            for (ExternalFilter filter : directorySet.getFilters()) {
                ResourceRootFilter resourceRootFilter = new ResourceRootFilter();
                resourceRootFilter.filterType = filter.getFilterType();
                resourceRootFilter.properties = filter.getPropertiesAsJsonMap();
                rootConfiguration.filters.add(resourceRootFilter);
            }
            container.add(rootConfiguration);
        }
    }

    private /* synthetic */ void lambda$generateBuildConfiguration$0(boolean finalConfigurationUpdateRequired, BuildManager buildManager, File gradleConfigFile, Element element, Map affectedConfigurationHash) {
        if (finalConfigurationUpdateRequired) {
            buildManager.clearState(this.myProject);
        }
        FileUtil.createIfDoesntExist((File)gradleConfigFile);
        try {
            JdomKt.write((Parent)element, (Path)gradleConfigFile.toPath());
            this.myModulesConfigurationHash.putAll(affectedConfigurationHash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

