/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunnerUtil {
    public static boolean isGradleModule(@NotNull Module module) {
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
    }

    @Nullable
    public static Location<PsiMethod> getMethodLocation(@NotNull Location contextLocation) {
        PsiClass containingClass;
        MethodLocation methodLocation = GradleRunnerUtil.getTestMethod(contextLocation);
        if (methodLocation == null) {
            return null;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
            methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
        }
        return methodLocation;
    }

    @Nullable
    public static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!TestFrameworks.getInstance().isTestMethod((PsiMethod)methodLocation.getPsiElement(), false)) continue;
            return methodLocation;
        }
        return null;
    }

    @Nullable
    public static String resolveProjectPath(@NotNull Module module) {
        List buildParticipants;
        String compositeProjectPath;
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (rootProjectPath == null || projectPath == null) {
            return null;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(rootProjectPath);
        if (projectSettings != null && projectSettings.getCompositeBuild() != null && projectSettings.getCompositeBuild().getCompositeDefinitionSource() == CompositeDefinitionSource.SCRIPT && (compositeProjectPath = (String)(buildParticipants = projectSettings.getCompositeBuild().getCompositeParticipants()).stream().filter(participant -> participant.getProjects().contains(projectPath)).findFirst().map(BuildParticipant::getRootPath).orElse(null)) != null) {
            return compositeProjectPath;
        }
        return rootProjectPath;
    }

    public static boolean isFromGroovyGradleScript(@Nullable Location location) {
        if (location == null) {
            return false;
        }
        return GradleRunnerUtil.isFromGroovyGradleScript(location.getPsiElement());
    }

    public static boolean isFromGroovyGradleScript(@NotNull PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return "gradle".equals(virtualFile.getExtension());
    }
}

