/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public final class AllInPackageGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return GradleExternalTaskConfigurationType.getInstance().getFactory();
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        TasksToRun tasksToRun = AllInPackageGradleConfigurationProducer.findTestsTaskToRun(configurationData.source, context.getProject());
        sourceElement.set((Object)configurationData.sourceElement);
        configuration.getSettings().setExternalProjectPath(configurationData.projectPath);
        configuration.getSettings().setTaskNames((List)tasksToRun);
        String filter = GradleExecutionSettingsUtil.createTestFilterFrom(configurationData.psiPackage, false);
        configuration.getSettings().setScriptParameters(filter);
        configuration.setName(AllInPackageGradleConfigurationProducer.suggestName(configurationData));
        return true;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)configurationData.module)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)configurationData.projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        if (!AllInPackageGradleConfigurationProducer.hasTasksInConfiguration(configurationData.source, context.getProject(), configuration.getSettings())) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        String filter = GradleExecutionSettingsUtil.createTestFilterFrom(configurationData.psiPackage, true);
        return scriptParameters.contains(filter);
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        ConfigurationData configurationData = this.extractConfigurationData(context);
        if (configurationData == null) {
            LOG.warn("Cannot extract configuration data from context, uses raw run configuration");
            performRunnable.run();
            return;
        }
        String locationName = String.format("'%s'", configurationData.getLocationName());
        DataContext dataContext = TestTasksChooser.contextWithLocationName(context.getDataContext(), locationName);
        PsiElement[] sourceElements = (PsiElement[])ArrayUtil.toObjectArray(PsiElement.class, (Object[])new Object[]{configurationData.sourceElement});
        this.getTestTasksChooser().chooseTestTasks(context.getProject(), dataContext, sourceElements, tasks -> {
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
            ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
            Function1 createFilter = e -> GradleExecutionSettingsUtil.createTestFilterFrom(configurationData.psiPackage, false);
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration((ExternalSystemTaskExecutionSettings)settings, (Module)context.getModule(), (List)tasks, (PsiElement[])sourceElements, (Function1)createFilter)) {
                LOG.warn("Cannot apply package test configuration, uses raw run configuration");
                performRunnable.run();
                return;
            }
            configuration.setName(AllInPackageGradleConfigurationProducer.suggestName(configurationData));
            performRunnable.run();
        });
    }

    @Nullable
    private ConfigurationData extractConfigurationData(ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        PsiElement contextLocation = context.getPsiLocation();
        if (contextLocation == null) {
            return null;
        }
        PsiPackage psiPackage = AllInPackageGradleConfigurationProducer.extractPackage(contextLocation);
        if (psiPackage == null) {
            return null;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return null;
        }
        PsiElement sourceElement = AllInPackageGradleConfigurationProducer.getSourceElement(module, contextLocation);
        if (sourceElement == null) {
            return null;
        }
        VirtualFile source = TestGradleConfigurationProducerUtilKt.getSourceFile(sourceElement);
        if (source == null) {
            return null;
        }
        return new ConfigurationData(module, psiPackage, sourceElement, source, projectPath);
    }

    @Nullable
    private static PsiElement getSourceElement(@NotNull Module module, @NotNull PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return element;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            return element;
        }
        if (element instanceof PsiPackage) {
            return AllInPackageGradleConfigurationProducer.getPackageDirectory(module, (PsiPackage)element);
        }
        return null;
    }

    @Nullable
    private static PsiDirectory getPackageDirectory(@NotNull Module module, @NotNull PsiPackage element) {
        PsiDirectory[] sourceDirs = element.getDirectories(GlobalSearchScope.moduleScope((Module)module));
        if (sourceDirs.length == 0) {
            return null;
        }
        return sourceDirs[0];
    }

    @Nullable
    static PsiPackage extractPackage(@NotNull PsiElement location) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)location);
        if (psiPackage == null) {
            return null;
        }
        if (psiPackage.getQualifiedName().isEmpty()) {
            return null;
        }
        return psiPackage;
    }

    @NotNull
    private static String suggestName(@NotNull ConfigurationData configurationData) {
        return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{configurationData.getLocationName()});
    }

    private static class ConfigurationData {
        @NotNull
        public final Module module;
        @NotNull
        public final PsiPackage psiPackage;
        @NotNull
        public final PsiElement sourceElement;
        @NotNull
        public final VirtualFile source;
        @NotNull
        public final String projectPath;

        private ConfigurationData(@NotNull Module module, @NotNull PsiPackage psiPackage, @NotNull PsiElement sourceElement, @NotNull VirtualFile source, @NotNull String projectPath) {
            this.module = module;
            this.psiPackage = psiPackage;
            this.sourceElement = sourceElement;
            this.source = source;
            this.projectPath = projectPath;
        }

        @NotNull
        public String getLocationName() {
            return this.psiPackage.getQualifiedName();
        }
    }
}

