/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleConsoleProperties;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleSMTestProxy;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class BeforeSuiteEvent
extends AbstractTestEvent {
    public BeforeSuiteEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        String testId = eventXml.getTestId();
        String parentTestId = eventXml.getTestParentId();
        String name = eventXml.getTestName();
        String fqClassName = eventXml.getTestClassName();
        if (StringUtil.isEmpty((String)parentTestId)) {
            this.registerTestProxy(testId, (SMTestProxy)this.getResultsViewer().getTestsRootNode());
        } else {
            SMTestProxy parentTest = this.findTestProxy(parentTestId);
            if (this.isHiddenTestNode(name, parentTest)) {
                this.registerTestProxy(testId, parentTest);
            } else {
                String locationUrl = this.findLocationUrl(null, fqClassName);
                GradleSMTestProxy testProxy = new GradleSMTestProxy(name, true, locationUrl, null);
                testProxy.setLocator(this.getExecutionConsole().getUrlProvider());
                testProxy.setParentId(parentTestId);
                testProxy.setStarted();
                this.registerTestProxy(testId, testProxy);
            }
        }
    }

    @Override
    @NotNull
    protected String findLocationUrl(@Nullable String name, @NotNull String fqClassName) {
        return name == null ? "java:suite://" + fqClassName : "java:suite://" + StringUtil.getQualifiedName((String)fqClassName, (String)name);
    }

    private boolean isHiddenTestNode(String name, SMTestProxy parentTest) {
        return parentTest != null && !GradleConsoleProperties.SHOW_INTERNAL_TEST_NODES.value((AbstractProperty.AbstractPropertyContainer)this.getProperties()) && StringUtil.startsWith((CharSequence)name, (CharSequence)"Gradle Test Executor");
    }
}

